% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureRegrRSQ.R
\name{mlr_measures_regr.rsq}
\alias{mlr_measures_regr.rsq}
\alias{MeasureRegrRSQ}
\title{R-Squared}
\description{
Measure to compare true observed response with predicted response in regression tasks.
}
\details{
R Squared is defined as \deqn{
  1 - \frac{\sum_{i=1}^n w_i \left( t_i - r_i \right)^2}{\sum_{i=1}^n w_i \left( t_i - \bar{t} \right)^2},
}{
  1 - sum(w * (t - r)^2) / sum(w * (t - mean(t))^2),
}
where \eqn{\bar{t} = \frac{1}{n} \sum_{i=1}^n t_i} and \eqn{w_i} are weights.

Also known as coefficient of determination or explained variation.
It compares the squared error of the predictions relative to a naive model predicting the mean.

Note that weights are used to scale the squared error of individual predictions (both in the numerator and in the denominator),
but the "plug in" value \eqn{\bar{t}} is computed without weights.

This measure is undefined for constant \eqn{t}.
}
\section{Dictionary}{

This \link{Measure} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_measures} or with the associated sugar function \code{\link[=msr]{msr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_measures$get("regr.rsq")
msr("regr.rsq")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Range: \eqn{(-\infty, 1]}{(-Inf, 1]}
\item Minimize: FALSE
\item Average: macro
\item Required Prediction: \dQuote{response}
\item Required Packages: \CRANpkg{mlr3}
}
}

\section{Parameters}{

Empty ParamSet
}

\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-eval}
\item Package \CRANpkg{mlr3measures} for the scoring functions.
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}
\code{as.data.table(mlr_measures)} for a table of available \link[=Measure]{Measures} in the running session (depending on the loaded packages).
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
}

Other Measure: 
\code{\link{Measure}},
\code{\link{MeasureClassif}},
\code{\link{MeasureRegr}},
\code{\link{MeasureSimilarity}},
\code{\link{mlr_measures}},
\code{\link{mlr_measures_aic}},
\code{\link{mlr_measures_bic}},
\code{\link{mlr_measures_classif.costs}},
\code{\link{mlr_measures_debug_classif}},
\code{\link{mlr_measures_elapsed_time}},
\code{\link{mlr_measures_internal_valid_score}},
\code{\link{mlr_measures_oob_error}},
\code{\link{mlr_measures_regr.pinball}},
\code{\link{mlr_measures_selected_features}}
}
\concept{Measure}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3:MeasureRegr]{mlr3::MeasureRegr}} -> \code{MeasureRSQ}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeasureRSQ-new}{\code{MeasureRegrRSQ$new()}}
\item \href{#method-MeasureRSQ-clone}{\code{MeasureRegrRSQ$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="aggregate"><a href='../../mlr3/html/Measure.html#method-Measure-aggregate'><code>mlr3::Measure$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureRSQ-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureRSQ-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureRegrRSQ$new(pred_set_mean = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pred_set_mean}}{\code{logical(1)}\cr
If \code{TRUE}, the mean of the true values is calculated on the prediction set.
If \code{FALSE}, the mean of the true values is calculated on the training set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeasureRSQ-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeasureRSQ-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureRegrRSQ$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
