% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure_custom_resampled.R
\name{makeCustomResampledMeasure}
\alias{makeCustomResampledMeasure}
\title{Construct your own resampled performance measure.}
\usage{
makeCustomResampledMeasure(measure.id, aggregation.id, minimize = TRUE,
  properties = character(0L), fun, extra.args = list(), best = NULL,
  worst = NULL, measure.name = measure.id,
  aggregation.name = aggregation.id, note = "")
}
\arguments{
\item{measure.id}{[\code{character(1)}]\cr
Short name of measure.}

\item{aggregation.id}{[\code{character(1)}]\cr
Short name of aggregation.}

\item{minimize}{[\code{logical(1)}]\cr
Should the measure be minimized?
Default is \code{TRUE}.}

\item{properties}{[\code{character}]\cr
Set of measure properties. Some standard property names include:
\describe{
  \item{classif}{Is the measure applicable for classification?}
  \item{classif.multi}{Is the measure applicable for multi-class classification?}
  \item{regr}{Is the measure applicable for regression?}
  \item{surv}{Is the measure applicable for survival?}
  \item{costsens}{Is the measure applicable for cost-sensitive learning?}
  \item{req.pred}{Is prediction object required in calculation? Usually the case.}
  \item{req.truth}{Is truth column required in calculation? Usually the case.}
  \item{req.task}{Is task object required in calculation? Usually not the case}
  \item{req.model}{Is model object required in calculation? Usually not the case.}
  \item{req.feats}{Are feature values required in calculation? Usually not the case.}
  \item{req.prob}{Are predicted probabilites required in calculation? Usually not the case, example would be AUC.}
}
Default is \code{character(0)}.}

\item{fun}{[\code{function(task, group, pred, extra.args)}]\cr
Calculates performance value from \code{\link{ResamplePrediction}} object.
For rare cases you can also use the task, the grouping or the extra arguments \code{extra.args}.}

\item{extra.args}{[\code{list}]\cr
List of extra arguments which will always be passed to \code{fun}.
Default is empty list.}

\item{best}{[\code{numeric(1)}]\cr
Best obtainable value for measure.
Default is -\code{Inf} or \code{Inf}, depending on \code{minimize}.}

\item{worst}{[\code{numeric(1)}]\cr
Worst obtainable value for measure.
Default is \code{Inf} or -\code{Inf}, depending on \code{minimize}.}

\item{measure.name}{[\code{character(1)}]\cr
Long name of measure.
Default is \code{measure.id}.}

\item{aggregation.name}{[\code{character(1)}]\cr
Long name of the aggregation.
Default is \code{aggregation.id}.}

\item{note}{[\code{character}] \cr
Description and additional notes for the measure. Default is \dQuote{}.}
}
\value{
[\code{\link{Measure}}].
}
\description{
Construct your own performance measure, used after resampling.
Note that individual training / test set performance values will be set to \code{NA}, you
only calculate an aggregated value. If you can define a function that makes sense
for every single training / test set, implement your own \code{\link{Measure}}.
}
\seealso{
Other performance: \code{\link{estimateRelativeOverfitting}},
  \code{\link{makeCostMeasure}}, \code{\link{makeMeasure}},
  \code{\link{measures}}, \code{\link{performance}}
}

