% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.WrappedModel}
\alias{predict.WrappedModel}
\title{Predict new data.}
\usage{
\method{predict}{WrappedModel}(object, task, newdata, subset = NULL, ...)
}
\arguments{
\item{object}{[\code{\link{WrappedModel}}]\cr
Wrapped model, result of \code{\link{train}}.}

\item{task}{[\code{\link{Task}}]\cr
The task. If this is passed, data from this task is predicted.}

\item{newdata}{[\code{data.frame}]\cr
New observations which should be predicted.
Pass this alternatively instead of \code{task}.}

\item{subset}{[\code{integer} | \code{logical}]\cr
Selected cases. Either a logical or an index vector.
By default all observations are used.}

\item{...}{[any]\cr
Currently ignored.}
}
\value{
[\code{\link{Prediction}}].
}
\description{
Predict the target variable of new data using a fitted model.
What is stored exactly in the [\code{\link{Prediction}}] object depends
on the \code{predict.type} setting of the \code{\link{Learner}}.
If \code{predict.type} was set to \dQuote{prob} probability thresholding
can be done calling the \code{\link{setThreshold}} function on the
prediction object.

The row names of the input \code{task} or \code{newdata} are preserved in the output.
}
\examples{
# train and predict
train.set = seq(1, 150, 2)
test.set = seq(2, 150, 2)
model = train("classif.lda", iris.task, subset = train.set)
p = predict(model, newdata = iris, subset = test.set)
print(p)
predict(model, task = iris.task, subset = test.set)

# predict now probabiliies instead of class labels
lrn = makeLearner("classif.lda", predict.type = "prob")
model = train(lrn, iris.task, subset = train.set)
p = predict(model, task = iris.task, subset = test.set)
print(p)
getPredictionProbabilities(p)
}
\seealso{
Other predict: \code{\link{asROCRPrediction}},
  \code{\link{getPredictionProbabilities}},
  \code{\link{getPredictionResponse}},
  \code{\link{plotViperCharts}},
  \code{\link{setPredictThreshold}},
  \code{\link{setPredictType}}
}
