% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_entire_gwas_pipeline.R
\name{run_entire_gwas_pipeline}
\alias{run_entire_gwas_pipeline}
\title{MLMM, model selection and effects estimation}
\usage{
run_entire_gwas_pipeline(Y, XX, KK, nbchunks = 2, maxsteps = 20,
  cofs = NULL, female = NULL, male = NULL,threshold=NULL)
}
\arguments{
\item{Y}{A numeric named vector where the names are individuals' names and the values their phenotype. The names of Y will be matched to the row names of X.}

\item{XX}{A list of length one, two or three matrices depending on the model. Matrices are n by m matrix, where n=number of individuals, m=number of SNPs, with rownames(X)=individual names, and colnames(X)=SNP names.

- additive: a single matrix

- additive+dominance: two matrices

- female+male: two matrices with the female one first

- female+male+interaction: three matrices with the female first, the male then the interaction}

\item{KK}{a list of one, two or three matrices depending on the models

- additive: a n by n matrix, where n=number of individuals, with rownames()=colnames()=individual names

- additive+dominance: two n by n matrices, where n=number of individuals, with rownames()=colnames()=individual names

- female+male: a n.female by n.female matrix, with rownames()=colnames()=female names and a n.male by n.male matrix, with rownames()=colnames()=male names

- female+male+interaction: the same two matrices as the model female+male and a n by n matrix, where n=number of individuals, with rownames()=colnames()=individual names}

\item{nbchunks}{An integer defining the number of chunks of matrices to run the analysis, allows to decrease the memory usage. minimum=2, increase it if you do not have enough memory}

\item{maxsteps}{An integer >= 3. Maximum number of steps desired in the forward approach. The forward approach breaks automatically once the pseudo-heritability is close to 0, however to avoid doing too many steps in case the pseudo-heritability does not reach a value close to 0, this parameter is also used.}

\item{cofs}{A n by q matrix, where n=number of individuals, q=number of fixed effect, with rownames()=individual names and with column names, forbidden head of column names for this matrix "eff1_" and usage of special characters as "*","/","&"}

\item{female}{A factor of levels female names and length n, only for the last two models}

\item{male}{A factor of levels male names and length n, only for the last two models}

\item{threshold}{a value to declare the significant p value. The default value is Bonferroni 0.05}
}
\value{
A named list with 2 or 3 elements:
\itemize{
    \item pval: the return value of \code{\link{mlmm_allmodels}}
    \item eBic: the return value of \code{\link{eBIC_allmodels}}
    \item threshold: the return value of \code{\link{threshold_allmodels}}
    \item effects: the return value of \code{\link{Estimation_allmodels}}, only if there is at least one marker in the model selected by lowest eBIC.
}
}
\description{
Internaly run functions of the mlmm.gwas package:
\itemize{
  \item \code{\link{mlmm_allmodels}} (GWAS)
  \item \code{\link{frommlmm_toebic}}
  \item \code{\link{eBIC_allmodels}} (model selection)
  \item \code{\link{threshold_allmodels}}
  \item \code{\link{fromeBICtoEstimation}}
  \item \code{\link{Estimation_allmodels}} (effects estimation)
}
}
\examples{
data("mlmm.gwas.AD")
results <- run_entire_gwas_pipeline(floweringDateAD, list(Xa), list(K.add))
}
