% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_metrics.R
\name{metric}
\alias{metric}
\title{metric}
\usage{
metric(name)
}
\arguments{
\item{name}{A metric name. Accepted names are the names of the metric
function exported from the \code{mlr3measures} R package.}
}
\value{
Returns a function that can be used as function to calculate the
performance metric throughout the experiments.
}
\description{
Returns a metric function which can be used for the experiments
(especially the cross-validation experiments) to compute the performance.
}
\details{
This function is a utility function to select performance metrics from the
\code{mlr3measures} R package and to reformat them into a form that is required
by the \code{mlexperiments} R package. For \code{mlexperiments} it is required that
a metric function takes the two arguments \code{ground_truth}, and \code{predictions},
as well as additional names arguments that are necessary to compute the
performance, which are provided via the ellipsis argument (...).
When using the performance metric with an experiment of class
\code{"MLCrossValidation"}, such arguments can be defined as a list provided to
the field \code{performance_metric_args} of the R6 class.
The main purpose of \code{mlexperiments::metric()} is convenience and to
re-use already existing implementations of the metrics. However, custom
functions can be provided easily to compute the performance of the
experiments, simply by providing a function that takes the above mentioned
arguments and returns one performance metric value.
}
\examples{
metric("auc")

}
