#' Internal dataset containing MLB Gameday IDs.
#' 
#' A character set with most available gids and the date at which they were played.
#' Note they are ordered from oldest game to newest game.
#' 
#' @docType data
#' @keywords internal
#' 
#' @usage data(game_ids)
#' @note last updated 2017-08-23
#'
"game_ids"


#' Internal dataset containing MLB Player IDs.
#' 
#' A character set with most player name and player ids.
#' 
#' @docType data
#' @keywords internal
#' 
#' @usage data(player_ids)
#' @note last updated 2017-09-16
#'
"player_ids"

#' Internal dataset containing MLB Umpire IDs.
#' 
#' A character set with most player name and player ids.
#' 
#' @docType data
#' @keywords internal
#' 
#' @usage data(umpire_ids)
#' @note last updated 2017-09-16
#'
"umpire_ids"

#' Internal dataset containing MLB team IDs.
#' 
#' A character set with most player name and player ids.
#' 
#' @docType data
#' @keywords internal
#' 
#' @usage data(team_ids)
#' @note last updated 2017-09-21
#'
"team_ids"

#' Internal dataset containing MLB team IDs.
#' 
#' A character set with most player name and player ids.
#' 
#' @docType data
#' @keywords internal
#' 
#' @usage data(venue_ids)
#' @note last updated 2017-09-21
#'
"venue_ids"

#' Internal dataset with coordinates for an average strike zone. K-zone oundreis borrowed from the book "Analyzing Baseball Data with R."
#' 
#' 
#' @docType data
#' @keywords internal
#' 
#' @usage data(kzone)
#' @note last updated 2017-10-12
#'
"kzone"