% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parplot.R
\name{parplot}
\alias{parplot}
\alias{parplot.multistart.saem.mmkin}
\title{Plot parameter variability of multistart objects}
\usage{
parplot(object, ...)

\method{parplot}{multistart.saem.mmkin}(
  object,
  llmin = -Inf,
  llquant = NA,
  scale = c("best", "median"),
  lpos = "bottomleft",
  main = "",
  ...
)
}
\arguments{
\item{object}{The \link{multistart} object}

\item{\dots}{Passed to \link{boxplot}}

\item{llmin}{The minimum likelihood of objects to be shown}

\item{llquant}{Fractional value for selecting only the fits with higher
likelihoods. Overrides 'llmin'.}

\item{scale}{By default, scale parameters using the best
available fit.
If 'median', parameters are scaled using the median parameters from all fits.}

\item{lpos}{Positioning of the legend.}

\item{main}{Title of the plot}
}
\description{
Produces a boxplot with all parameters from the multiple runs, scaled
either by the parameters of the run with the highest likelihood,
or by their medians as proposed in the paper by Duchesne et al. (2021).
}
\details{
Starting values of degradation model parameters and error model parameters
are shown as green circles. The results obtained in the original run
are shown as red circles.
}
\references{
Duchesne R, Guillemin A, Gandrillon O, Crauste F. Practical
identifiability in the frame of nonlinear mixed effects models: the example
of the in vitro erythropoiesis. BMC Bioinformatics. 2021 Oct 4;22(1):478.
doi: 10.1186/s12859-021-04373-4.
}
\seealso{
\link{multistart}
}
