% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mixed.mmkin.R
\name{plot.mixed.mmkin}
\alias{plot.mixed.mmkin}
\title{Plot predictions from a fitted nonlinear mixed model obtained via an mmkin row object}
\usage{
\method{plot}{mixed.mmkin}(
  x,
  i = 1:ncol(x$mmkin),
  obs_vars = names(x$mkinmod$map),
  standardized = TRUE,
  xlab = "Time",
  xlim = range(x$data$time),
  resplot = c("predicted", "time"),
  pred_over = NULL,
  ymax = "auto",
  maxabs = "auto",
  ncol.legend = ifelse(length(i) <= 3, length(i) + 1, ifelse(length(i) <= 8, 3, 4)),
  nrow.legend = ceiling((length(i) + 1)/ncol.legend),
  rel.height.legend = 0.02 + 0.07 * nrow.legend,
  rel.height.bottom = 1.1,
  pch_ds = 1:length(i),
  col_ds = pch_ds + 1,
  lty_ds = col_ds,
  frame = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \link{mixed.mmkin}, \link{nlme.mmkin}}

\item{i}{A numeric index to select datasets for which to plot the individual predictions,
in case plots get too large}

\item{obs_vars}{A character vector of names of the observed variables for
which the data and the model should be plotted. Defauls to all observed
variables in the model.}

\item{standardized}{Should the residuals be standardized? Only takes effect if
\code{resplot = "time"}.}

\item{xlab}{Label for the x axis.}

\item{xlim}{Plot range in x direction.}

\item{resplot}{Should the residuals plotted against time or against
predicted values?}

\item{pred_over}{Named list of alternative predictions as obtained
from \link{mkinpredict} with a compatible \link{mkinmod}.}

\item{ymax}{Vector of maximum y axis values}

\item{maxabs}{Maximum absolute value of the residuals. This is used for the
scaling of the y axis and defaults to "auto".}

\item{ncol.legend}{Number of columns to use in the legend}

\item{nrow.legend}{Number of rows to use in the legend}

\item{rel.height.legend}{The relative height of the legend shown on top}

\item{rel.height.bottom}{The relative height of the bottom plot row}

\item{pch_ds}{Symbols to be used for plotting the data.}

\item{col_ds}{Colors used for plotting the observed data and the
corresponding model prediction lines for the different datasets.}

\item{lty_ds}{Line types to be used for the model predictions.}

\item{frame}{Should a frame be drawn around the plots?}

\item{...}{Further arguments passed to \code{\link{plot}}.}
}
\value{
The function is called for its side effect.
}
\description{
Plot predictions from a fitted nonlinear mixed model obtained via an mmkin row object
}
\examples{
ds <- lapply(experimental_data_for_UBA_2019[6:10],
 function(x) x$data[c("name", "time", "value")])
names(ds) <- paste0("ds ", 6:10)
dfop_sfo <- mkinmod(parent = mkinsub("DFOP", "A1"),
  A1 = mkinsub("SFO"), quiet = TRUE)
\dontrun{
f <- mmkin(list("DFOP-SFO" = dfop_sfo), ds, quiet = TRUE)
plot(f[, 3:4], standardized = TRUE)

# For this fit we need to increase pnlsMaxiter, and we increase the
# tolerance in order to speed up the fit for this example evaluation
f_nlme <- nlme(f, control = list(pnlsMaxIter = 120, tolerance = 1e-3))
plot(f_nlme)

}
}
\author{
Johannes Ranke
}
