% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIC.mmkin.R
\name{AIC.mmkin}
\alias{AIC.mmkin}
\alias{BIC.mmkin}
\title{Calculate the AIC for a column of an mmkin object}
\usage{
\method{AIC}{mmkin}(object, ..., k = 2)

\method{BIC}{mmkin}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{mmkin}}, containing only one
column.}

\item{\dots}{For compatibility with the generic method}

\item{k}{As in the generic method}
}
\value{
As in the generic method (a numeric value for single fits, or a
  dataframe if there are several fits in the column).
}
\description{
Provides a convenient way to compare different kinetic models fitted to the
same dataset.
}
\examples{

  \dontrun{ # skip, as it takes > 10 s on winbuilder
  f <- mmkin(c("SFO", "FOMC", "DFOP"),
    list("FOCUS A" = FOCUS_2006_A,
         "FOCUS C" = FOCUS_2006_C), cores = 1, quiet = TRUE)
  # We get a warning because the FOMC model does not converge for the
  # FOCUS A dataset, as it is well described by SFO

  AIC(f["SFO", "FOCUS A"]) # We get a single number for a single fit
  AIC(f[["SFO", "FOCUS A"]]) # or when extracting an mkinfit object

  # For FOCUS A, the models fit almost equally well, so the higher the number
  # of parameters, the higher (worse) the AIC
  AIC(f[, "FOCUS A"])
  AIC(f[, "FOCUS A"], k = 0) # If we do not penalize additional parameters, we get nearly the same
  BIC(f[, "FOCUS A"])        # Comparing the BIC gives a very similar picture

  # For FOCUS C, the more complex models fit better
  AIC(f[, "FOCUS C"])
  BIC(f[, "FOCUS C"])
  }

}
\author{
Johannes Ranke
}
