% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerFeedingLevel}
\alias{mizerFeedingLevel}
\title{Get feeding level needed to project standard mizer model}
\usage{
mizerFeedingLevel(params, n, n_pp, n_other, t, encounter, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{encounter}{A two dimensional array (predator species x predator size)
with the encounter rate.}

\item{...}{Unused}
}
\value{
A two dimensional array (predator species x predator size) with the
feeding level.
}
\description{
You would not usually call this function directly but instead use
\code{\link[=getFeedingLevel]{getFeedingLevel()}}, which then calls this function unless an alternative
function has been registered, see below.
}
\section{Feeding level}{

The feeding level \eqn{f_i(w)} is the
proportion of its maximum intake rate at which the predator is actually
taking in fish. It is calculated from the encounter rate \eqn{E_i} and the
maximum intake rate \eqn{h_i(w)} as
\deqn{f_i(w) = \frac{E_i(w)}{E_i(w)+h_i(w)}.}{E_i(w)/(E_i(w)+h_i(w)).}
The encounter rate \eqn{E_i} is passed as an argument or calculated with
\code{\link[=getEncounter]{getEncounter()}}. The maximum intake rate \eqn{h_i(w)} is
taken from the \code{params} object, and is set with
\code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
As a consequence of the above expression for the feeding level,
\eqn{1-f_i(w)} is the proportion of the food available to it that the
predator actually consumes.
}

\section{Your own feeding level function}{

By default \code{\link[=getFeedingLevel]{getFeedingLevel()}} calls \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}. However you can
replace this with your own alternative feeding level function. If
your function is called \code{"myFeedingLevel"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "FeedingLevel", "myFeedingLevel")
}

Your function will then be called instead of \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}, with the
same arguments.
}

\seealso{
The feeding level is used in \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}} and in
\code{\link[=mizerPredRate]{mizerPredRate()}}.

Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerERepro}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFMort}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
