% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerParams-class.R
\name{setColours}
\alias{setColours}
\alias{getColours}
\title{Set line colours to be used in mizer plots}
\usage{
setColours(params, colours)

getColours(params)
}
\arguments{
\item{params}{A MizerParams object}

\item{colours}{A named list or named vector of line colours.}
}
\value{
The MizerParams object with updated line colours
}
\description{
Colours for names that already had a colour set will be overwritten by
the colour you specify. Colours for names that did not yet have a colour
will be appended to the list of colours.
}
\examples{
params <- NS_params
params <- setColours(params, list("Cod" = "red", "Haddock" = "#00ff00"))
plotSpectra(params)
getColours(params)
}
