% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_dynamics.R
\name{resource_constant}
\alias{resource_constant}
\title{Keep resource abundance constant}
\usage{
resource_constant(params, n, n_pp, n_other, rates, t, dt, ...)
}
\arguments{
\item{params}{A \link{MizerParams} object}

\item{n}{A matrix of species abundances (species x size)}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list with the abundances of other components}

\item{rates}{A list of rates as returned by \code{\link[=mizerRates]{mizerRates()}}}

\item{t}{The current time}

\item{dt}{Time step}

\item{...}{Unused}
}
\value{
Vector containing resource spectrum at next timestep
}
\description{
This function can be used instead of the standard
\code{\link[=resource_semichemostat]{resource_semichemostat()}} in order to keep the resource
spectrum constant over time.
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter,
                                resource_dynamics = "resource_constant")
}
}
