% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getPredRate}
\alias{getPredRate}
\title{Get predation rate}
\usage{
getPredRate(
  params,
  n = initialN(params),
  n_pp = initialNResource(params),
  n_other = initialNOther(params),
  t = 0,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{...}{Unused}
}
\value{
A two dimensional array (predator species x prey size),
where the prey size runs over fish community plus resource spectrum.
}
\description{
Calculates the potential rate (in units 1/year) at which a prey individual of
a given size \eqn{w} is killed by predators from species \eqn{j}. In formulas
\deqn{{\tt pred\_rate}_j(w_p) = \int \phi_j(w,w_p) (1-f_j(w)) 
  \gamma_j(w) N_j(w) \, dw.}{pred_rate_j(w_p) = \int\phi_i(w,w_p) (1-f_i(w)) 
  \gamma_i(w) N_i(w) dw.}
This potential rate is used in \code{\link[=getPredMort]{getPredMort()}} to
calculate the realised predation mortality rate on the prey individual.
}
\section{Your own predation rate function}{

By default \code{\link[=getPredRate]{getPredRate()}} calls \code{\link[=mizerPredRate]{mizerPredRate()}}. However you can
replace this with your own alternative predation rate function. If
your function is called \code{"myPredRate"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "PredRate", "myPredRate")
}

Your function will then be called instead of \code{\link[=mizerPredRate]{mizerPredRate()}}, with
the same arguments.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the feeding level at one time step
getPredRate(params, n = N(sim)[15, , ], n_pp = NResource(sim)[15, ])
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getFeedingLevel}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getRates}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
