% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotBiomass}
\alias{plotBiomass}
\alias{plotBiomass,MizerSim-method}
\title{Plot the biomass of species through time}
\usage{
plotBiomass(sim, ...)

\S4method{plotBiomass}{MizerSim}(sim,
  species = sim@params@species_params$species[!is.na(sim@params@A)],
  start_time = as.numeric(dimnames(sim@n)[[1]][1]),
  end_time = as.numeric(dimnames(sim@n)[[1]][dim(sim@n)[1]]),
  y_ticks = 6, print_it = TRUE, ylim = c(NA, NA), total = FALSE,
  background = TRUE, ...)
}
\arguments{
\item{sim}{An object of class \linkS4class{MizerSim}}

\item{...}{Other arguments to pass to \code{getBiomass} method, for example
\code{min_w} and \code{max_w}}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{start_time}{The first time to be plotted. Default is the beginning
of the time series.}

\item{end_time}{The last time to be plotted. Default is the end of the
time series.}

\item{y_ticks}{The approximate number of ticks desired on the y axis}

\item{print_it}{Display the plot, or just return the ggplot2 object. Default
value is TRUE}

\item{ylim}{A numeric vector of length two providing limits of for the
y axis. Use NA to refer to the existing minimum or maximum. Any values
below 1e-20 are always cut off.}

\item{total}{A boolean value that determines whether the total biomass from
all species is plotted as well. Default is FALSE}

\item{background}{A boolean value that determines whether background species
are included. Ignored if the model does not contain background species.
Default is TRUE.}
}
\value{
A ggplot2 object
}
\description{
After running a projection, the biomass of each species can be plotted
against time. The biomass is calculated within user defined size limits 
(min_w, max_w, min_l, max_l, see \code{\link{getBiomass}}).
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=20, t_save = 0.2)
plotBiomass(sim)
plotBiomass(sim, species = c("Cod", "Herring"), total = TRUE)
plotBiomass(sim, min_w = 10, max_w = 1000)
plotBiomass(sim, start_time = 10, end_time = 15)
plotBiomass(sim, y_ticks = 3)
}
}
\seealso{
\code{\link{getBiomass}}
}
