% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctx_node_vlmc.R
\name{cutoff.ctx_node}
\alias{cutoff.ctx_node}
\title{Cut off value for pruning a node in the context tree of a VLMC}
\usage{
\method{cutoff}{ctx_node}(model, scale = c("quantile", "native"), raw = FALSE, ...)
}
\arguments{
\item{model}{a \code{ctx_node} object as returned by \code{\link[=find_sequence]{find_sequence()}}}

\item{scale}{specify whether the results should be "native" log likelihood
ratio values or expressed in a "quantile" scale of a chi-squared
distribution (defaults to "quantile").}

\item{raw}{specify whether the returned values should be limit values
computed in the model or modified values that guarantee pruning (see
details in \code{\link[=cutoff.vlmc]{cutoff.vlmc()}})}

\item{...}{additional arguments for the \code{cutoff} function.}
}
\value{
a cut off value
}
\description{
This function returns the cut off value associated to a specific node in the
context tree interpreted as a VLMC. The node is represented by a \code{ctx_node}
object as returned by \code{\link[=find_sequence]{find_sequence()}} or \code{\link[=contexts]{contexts()}}. For details, see
\code{\link[=cutoff.vlmc]{cutoff.vlmc()}}.
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.25, 0.5, 0.75, 1))))
model <- vlmc(dts)
model_ctxs <- contexts(model)
cutoff(model_ctxs[[1]])
cutoff(model_ctxs[[2]], scale = "native", raw = TRUE)
}
\seealso{
\code{\link[=cutoff]{cutoff()}}
}
