% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysing.R
\name{get_summary_statistics}
\alias{get_summary_statistics}
\title{Obtain summary statistics of response error}
\usage{
get_summary_statistics(
  data,
  unit = "degrees",
  id_var = "id",
  response_var = "response",
  target_var = "target",
  set_size_var = NULL,
  condition_var = NULL
)
}
\arguments{
\item{data}{A data frame with columns containing: participant identifier
(declared via variable 'id_var'); the participants' response per trial
('response_var'); the target value ('target_var'); and, if applicable, the
set size of each response ('set_size_var'), and the condition of each
response ('condition_var').}

\item{unit}{The unit of measurement in the data frame: "degrees"
(measurement is in degrees, from 0 to 360); "degrees_180 (measurement is in
degrees, but limited to 0 to 180); or "radians" (measurement is in radians,
from pi to 2 * pi, but could also be already in -pi to pi).}

\item{id_var}{The quoted column name coding for participant id. If the data
is from a single participant (i.e., there is no id column) set to NULL.}

\item{response_var}{The quoted column name coding for the participants'
responses}

\item{target_var}{The quoted column name coding for the target value.}

\item{set_size_var}{The quoted column name (if applicable) coding for the
set size of each response.}

\item{condition_var}{The quoted column name (if applicable) coding for the
condition of each response.}
}
\value{
Returns a data frame containing the summary statistics
\code{mean_absolute_error}, \code{resultant_vector_length},
\code{precision}, and \code{bias} per participant (if applicable),
set-size (if applicable), and condition (if applicable).
}
\description{
Returns participant-level summary statistic data of response error estimates
ready for inferential analysis. Note that the function does not actually
conduct the analysis.
}
\examples{
# load an example data frame
data(bays2009_full)

# calculate the summary statistics per condition and per set size
summary_data <- get_summary_statistics(data = bays2009_full,
                                      unit = "radians",
                                      condition_var = "duration",
                                      set_size_var = "set_size")

}
