\name{rmixreg}
\alias{rmixreg}
\alias{rmixreg.default}
\alias{rmixreg.mixreg}
\title{
    Simulate data from a mixture of regressions model.
}
\description{
    Simulate data from a mixture of regressions model, as specified
    by the user or as fitted to a data set.  The simulation may be
    done either in a parametric or \dQuote{semiparametric} manner.
}
\usage{
rmixreg(x, ...)
\method{rmixreg}{default}(x, nobs, theta, seed = NULL,
                          xNms=NULL, yNm = "y", ...)
\method{rmixreg}{mixreg}(x, semiPar = FALSE, conditional=semiPar,
                         seed = NULL, ...) 
}
\arguments{
  \item{x}{
  For the default method, this is a numeric vector constituting
  a predictor for a regression model, or a matrix whose columns
  form such predictors.  The number of columns of \code{x} (or
  of \code{as.matrix(x)}) must be equal to the number of linear
  coefficients, or be one less than this number, otherwise an
  error is thrown.  If the number of columns of \code{x} is one
  less than the number of linear coefficients then it is assumed
  that the missing predictor is the intercept and a column of 1s
  gets prepended (internally).  Note that the number of linear
  coefficients is determined from argument \code{theta} (see below).
  Note that \code{x} may be set equal to \code{NULL} in which case
  data are generated from a model with no predictors, i.e. from
  a scalar mixture model.  In this case \code{nobs} (see below)
  must be specified.

  Data from a scalar mixture model may also be generated by
  specifying \code{x} to be a vector of 1s.  (In this case
  \code{nobs} is ignored.)

  For the \code{"mixreg"} method this is an object of class
  \code{"mixreg"} as returned by the function \code{\link{mixreg}()}.
}
  \item{nobs}{
  Integer scalar, specifying the number of observations to be
  generated.  Used only if argument \code{x} in \code{NULL}.
  Otherwise the number of observations is determined from
  the length or number of rows of \code{x}.
}
  \item{theta}{
  Either a list or a matrix specifying the parameters of the model
  from which data are to be simulated. If it is a list it should
  have components \code{beta}, \code{sigsq} and \code{lambda}.
  Each of these components is in turn a list of length \code{K} where
  \code{K} is the number of components in the model.  The \code{k}th
  entry of \code{beta} is a vector of regression coefficients.
  These vectors must all have the same length.  The \code{k}th
  entry of \code{sigsq} is a positive scalar specifying the error
  variance for the \code{k}th component.  The \code{k}th entry of
  \code{lambda} is a probability (positive scalar, less than 1)
  specifying the probability that an observation corresponds to the
  \code{k}th component.  Note that the \code{lambda} values must
  sum to 1.  If \code{theta} is a matrix it is of dimension \eqn{K
  \times np}{K x np} where \code{np} is the number of parameters.
  Note that \code{np} is equal to \eqn{p + 2} where \eqn{p} is the
  number of linear regression coefficients (the other 2 parameters
  being \code{sigsq} and \code{lambda}).  The rows of this matrix
  correspond to components of the mixture and the columns to the
  parameters of the model.
}
  \item{seed}{
  A numeric scalar.  If not an integer it gets rounded to the nearest
  integer (so \code{seed=pi} has the same impact as \code{seed=3}.
  If not supplied, \code{seed} is selected randomly from \code{1,
  2, \dots, 1e5}.  The seed for random number generation is set to
  \code{seed} in \code{rmixreg()} before any random number generation
  is done.
}
  \item{xNms}{
  Character vector of names for the predictors \emph{other than}
  the intercept (if there is one).  This vector must be of length
  equal to the number of (non-intercept) predictors.  This is
  equal to the number of columns of \code{x} \emph{prior} to its
  having a column of 1s prepended (given that this augmentation
  of \code{x} does indeed take place).  If not supplied the names
  used are \code{X1}, ..., \code{Xn} where \code{n} is the number
  of predictors.  (Except, if there is only one predictor it is
  named by the name of the \code{x} variable.)
}
  \item{yNm}{
  Character scalar; a name for the response.
}
  \item{semiPar}{
  Logical scalar.  Should the simulation be done \dQuote{semiparametrically}?
  (See \bold{Details}.)
}
\item{conditional}{
  Logical scalar; should the component-selection probabilities be
  determined conditionally upon the observations?
}
  \item{\dots}{
  Not used.
}
}
\details{
In this context \dQuote{parametric} bootstrapping means that the
bootstrap data sets are generated by simulating from the fitted
\code{ncomp} model parameters, using Gaussian errors.  In contrast
semiparametric bootstrapping means that the errors are generated by
resampling from the residuals.  Since at each predictor value there
are \code{ncomp} residuals, one for each component of the model,
the errors are selected from these \code{ncomp} possibilities.
If the argument \code{conditional} is \code{TRUE} then the selection
probabilities at this step are the conditional probabilities, of
the observation being generated by each component of the model,
given that observation.  If \code{conditional} is \code{FALSE} then
these probabilities are the corresponding entries of \code{lambda}
(see \bold{Value}.  The residuals are sampled independently
in either case.  The procedure is termed \emph{semi}parametric
(rather than non-parametric) since the sampling probabilities depend
on the parameters of the model.  Note that it makes no sense to
specify \code{conditional=TRUE} if \code{semiPar} is \code{FALSE}.
Doing so will generate an error.
}
\value{
  A data frame whose columns consist of the predictors and the
  simulated response.  For the default method the predictor are the
  columns of the matrix specified by argument \code{x}.  They have
  names given by argument \code{xNms} if this was provided and by
  \code{X1}, \code{X2}, \dots, \code{Xn} (where \code{n} is the
  number of columns of \code{x}) or simply \code{x} if there is
  only a single predictor.  For the \code{"mixreg"} method the
  columns are the same as those of \code{x$data}, with response
  column replaced by the simulated response.
}
\author{Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\references{
Turner, T. R.  (2000) Estimating the rate of spread of a
viral infection of potato plants via mixtures of regressions.
\emph{Applied Statistics} \bold{49}, Part 3 pp. 371 -- 384.
}

\seealso{
    \code{\link{mixreg}()}
}
\examples{
   fit  <- mixreg(plntsInf ~ aphRel, ncomp=2, data=aphids)
   sim1 <- rmixreg(fit)
   with(sim1,plot(aphRel,plntsInf,,main="Parametric simulation"))
   sim2 <- rmixreg(fit,semiPar=TRUE)
   with(sim2,plot(aphRel,plntsInf,,main="Semiparametric simulation"))
   x    <- cbind(1:50,rnorm(50))
   pmat <- matrix(c(3,5,0.01,1600,0.7,1,2,-0.01,100,0.3),nrow=2,byrow=TRUE)
   sim3 <- rmixreg(x,theta=pmat,seed=42)
   with(sim3,plot(X1,y,main="Using rmixreg.default; predictor 1"))
   with(sim3,plot(X2,y,main="Using rmixreg.default; predictor 2"))
   pmat <- matrix(c(10,2,0.7,3,1,0.3),nrow=2,byrow=TRUE)
   sim4 <- rmixreg(x=rep(1,50),theta=pmat,seed=17)
   sim5 <- rmixreg(x=NULL,nobs=50,theta=pmat,seed=17) # Same as sim4 but
                                                      # with no columns of 1s.
   chk4 <- mixreg(y~1,data=sim4,ncomp=2,seed=116) 
   chk5 <- mixreg(y~1,data=sim5,ncomp=2,seed=116) # Same-same.
}
\keyword{ datagen }
