% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mixdir}
\alias{predict.mixdir}
\title{Predict the class of a new observation.}
\usage{
\method{predict}{mixdir}(object, newdata, ...)
}
\arguments{
\item{object}{the result from a call to \code{mixdir()}. It needs to have the
fields lambda and category_prob. lambda is a vector of probabilities for each category.
category_prob a list of a list of a named vector with probabilities
for each feature, latent class and possible category.}

\item{newdata}{a named vector with a single new observation or a data.frame
with the same structure as the original data used for fitting the model.
Missing features or features not encountered during training are replaced by
NA.}

\item{...}{currently unused}
}
\value{
A matrix of with the same number of rows as the input and one column for each latent class.
}
\description{
Predict the class of a new observation.
}
\examples{
  data("mushroom")
  X <- as.matrix(mushroom)[1:30, ]

  res <- mixdir(X)

  # Predict Class
  predict(res, mushroom[40:45, ])
  predict(res, c(`gill-color`="black"))
}
