% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenotypeFreq.R
\name{GenotypeFreq}
\alias{GenotypeFreq}
\title{Calculate Genotype Frequency###}
\usage{
GenotypeFreq(x,sep,expect=TRUE)
}
\arguments{
\item{x}{a dataframe of genotype data with rownames of sample ID and column names of markers.}

\item{sep}{allele separator in the imported genotype data. Note: when using the special character like "|", remember to protect it as "\\|"(default).}

\item{expect}{a logic variable. If expect is true, the function will calculate the expected genotype probabilities. If false, calculate the observed genotype frequencies.}
}
\value{
a dataframe of genotype frequencies. Each row denotes each genotype; each column denotes each loci. The order of markers follows x; the genotypes are ordered from homozygous to heterozygous.
}
\description{
Calculate Genotype Frequency###
}
\details{
This function calculates the observed or expected genotype frequency from dataset and allele frequency.#####
}
\examples{
require(mixIndependR)
x <- data.frame(SNP1=c("A|A","T|T","A|T","A|T"),
                STR1=c("12|12","13|14","13|13","14|15"))
GenotypeFreq(x,"\\\\|",expect=TRUE)
}
\references{
Chakraborty, R., Srinivasan, M. R., & Daiger, S. P. (1993, ISSN:0002-9297).
}
