% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.auxiliary.R
\name{na.auxiliary}
\alias{na.auxiliary}
\title{Auxiliary Variables Analysis}
\usage{
na.auxiliary(data, ..., model = NULL, estimator = c("ML", "MLR"),
             missing = c("fiml", "two.stage", "robust.two.stage", "doubly.robust"),
             tri = c("both", "lower", "upper"), weighted = FALSE, correct = FALSE,
             digits = 2, p.digits = 3, as.na = NULL, write = NULL, append = TRUE,
             check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a data frame with incomplete data, where missing
values are coded as \code{NA}.}

\item{...}{an expression indicating the variable names in \code{data},
e.g., \code{na.auxiliary(dat, x1, x2, x3)}. Note that the
operators \code{.}, \code{+}, \code{-}, \code{~}, \code{:},
\code{::}, and \code{!} can also be used to select variables,
see 'Details' in the \code{\link{df.subset}} function.}

\item{model}{a character string specifying the substantive model predicting
an continuous outcome variable using a set of predictor variables
to estimate semi-partial correlations between the outcome
variable and a set of candidate auxiliary variables. The default
setting is \code{model = NULL}, i.e., the function computes
Pearson product-moment correlation matrix and Cohen's d matrix.}

\item{estimator}{a character string indicating the estimator to be used
when estimating semi-partial correlation coefficients, i.e.,
\code{"ML"} for maximum likelihood parameter estimates with
conventional standard errors or \code{"MLR"} (default) maximum
likelihood parameter estimates with Huber-White robust standard
errors.}

\item{missing}{a character string indicating how to deal with missing data
when estimating semi-partial correlation coefficients,
i.e., \code{"fiml"} for full information maximum likelihood
method, \code{two.stage} for two-stage maximum likelihood
method, \code{robust.two.stage} for robust two-stage maximum
likelihood method, and \code{doubly-robust} for doubly-robust
method (see 'Details' in the \code{\link{item.cfa}} function).
The default setting is \code{missing = "fiml"}.}

\item{tri}{a character string indicating which triangular of the correlation
matrix to show on the console, i.e., \code{both} for upper and
lower triangular, \code{lower} (default) for the lower triangular,
and \code{upper} for the upper triangular.}

\item{weighted}{logical: if \code{TRUE} (default), the weighted pooled standard
deviation is used.}

\item{correct}{logical: if \code{TRUE}, correction factor for Cohen's d to
remove positive bias in small samples is used.}

\item{digits}{integer value indicating the number of decimal places digits
to be used for displaying correlation coefficients and Cohen's d
estimates.}

\item{p.digits}{an integer value indicating the number of decimal places
to be used for displaying the \emph{p}-value.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting
the analysis.}

\item{write}{a character string naming a file for writing the output into
either a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}) or Excel file with file extension
\code{".xlsx"}  (e.g., \code{"Output.xlsx"}). If the file
name does not contain any file extension, an Excel file will
be written.}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:
\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{data}}{data frame used for the current analysis}
\item{\code{model}}{lavaan model syntax for estimating the semi-partial correlations}
\item{\code{model.fit}}{fitted lavaan model for estimating the semi-partial correlations}
\item{\code{args}}{pecification of function arguments}
\item{\code{result}}{list with result tables}
}
\description{
This function computes (1) Pearson product-moment correlation matrix to identify
variables related to the incomplete variable (i.e., correlates of incomplete
variables), (2) Cohen's d matrix comparing cases with and without missing values
to identify variables related to the probability of missingness(i.e., correlates
of missingness), and (3) semi-partial correlations of an outcome variable
conditional on the predictor variables of a substantive model with a set of
candidate auxiliary variables to identify correlates of an incomplete outcome
variable as suggested by Raykov and West (2016).
}
\details{
Note that non-numeric variables (i.e., factors, character vectors, and logical
vectors) are excluded from to the analysis.
}
\examples{
# Example 1: Auxiliary variables
na.auxiliary(airquality)

# Example 2: Semi-partial correlation coefficients
na.auxiliary(airquality, model = "Ozone ~ Solar.R + Wind")

\dontrun{
# Example 3a: Write Results into a text file
na.auxiliary(airquality, write = "NA_Auxiliary.txt")

# Example 3a: Write Results into an Excel file
na.auxiliary(airquality, write = "NA_Auxiliary.xlsx")}
}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}. Guilford Press.

Graham, J. W. (2009). Missing data analysis: Making it work in the real world.
\emph{Annual Review of Psychology, 60}, 549-576.
https://doi.org/10.1146/annurev.psych.58.110405.085530

Raykov, T., & West, B. T. (2016). On enhancing plausibility of the missing at
random assumption in incomplete data analyses via evaluation of response-auxiliary
variable correlations. \emph{Structural Equation Modeling, 23}(1), 45–53.
https://doi.org/10.1080/10705511.2014.937848

van Buuren, S. (2018). \emph{Flexible imputation of missing data} (2nd ed.).
Chapman & Hall.
}
\seealso{
\code{\link{as.na}}, \code{\link{na.as}}, \code{\link{na.coverage}},
\code{\link{na.descript}}, \code{\link{na.indicator}}, \code{\link{na.pattern}},
\code{\link{na.prop}}, \code{\link{na.test}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
