% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examine_alpha_bound.R
\name{examine_alpha_bound}
\alias{examine_alpha_bound}
\title{Check Feasibility of Alpha Bound for Optimization Problem}
\usage{
examine_alpha_bound(
  alpha,
  n_person,
  sigma_x_info,
  sigma_y_info,
  alpha_type,
  score_max = 1,
  num_try = 1,
  method = "GA",
  ...
)
}
\arguments{
\item{alpha}{A numeric value representing the \code{alpha} value to check.}

\item{n_person}{An integer representing the number of individuals or rows in the data.}

\item{sigma_x_info}{A list containing the quadratic function information for sigma_x, including:
\itemize{
\item A matrix representing the quadratic coefficients for sigma_x.
\item A vector representing the linear coefficients for sigma_x.
\item A scalar constant term for sigma_x.
}}

\item{sigma_y_info}{A list containing the quadratic function information for sigma_y, including:
\itemize{
\item A matrix representing the quadratic coefficients for sigma_y.
\item A vector representing the linear coefficients for sigma_y.
\item A scalar constant term for sigma_y.
}}

\item{alpha_type}{A character string indicating whether the problem is to minimize or maximize alpha.
It must be either \code{'min'} or \code{'max'}.}

\item{score_max}{An integer representing the largest possible score for any test item. Default is 1.}

\item{num_try}{An integer specifying the number of times to run the optimization algorithm. Default is 1.}

\item{method}{A character string specifying the optimization method to use.
Options are \code{'GA'} (Genetic Algorithm), \code{'DEoptim'} (Differential Evolution), and \code{'nloptr'} (Sequential Least Squares Programming). Default is 'GA'.}

\item{...}{Additional parameters passed to the optimization algorithm.}
}
\value{
A list with the following elements:
\item{result}{A logical value indicating whether the \code{alpha} is feasible (\code{TRUE}) or not (\code{FALSE}).}
\item{x_value}{A numeric vector representing the optimal values of the decision variables, or \code{NULL} if not feasible.}
}
\description{
This function checks whether a given value of \code{alpha} is a feasible solution
to a min/max optimization problem using quadratic functions for sigma_x and sigma_y.
The function supports different optimization methods and iteratively attempts to solve the problem.
}
\details{
The function combines quadratic information from \code{sigma_x_info} and \code{sigma_y_info}
to form a new optimization problem. The optimization checks whether the value of \code{alpha} is feasible
for either a minimization or maximization problem, depending on the value of \code{alpha_type}.

The function supports multiple optimization methods, including Genetic Algorithm (GA),
Differential Evolution (DEoptim), and Sequential Least Squares Programming (nloptr).
Additional control parameters can be passed through the \code{...} argument to fine-tune the optimization process.

For each iteration, the function calls \code{qp_solver} with the combined quadratic function
and checks whether the objective function's value is feasible (i.e., less than or equal to 0).
}
\seealso{
\code{\link{qp_solver}}, \code{\link{compute_alpha_min}}, \code{\link{compute_alpha_max}}
}
