% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm.R
\name{pmm}
\alias{pmm}
\title{Predictive Mean Matching}
\usage{
pmm(xtrain, xtest, ytrain, k = 1L, seed = NULL)
}
\arguments{
\item{xtrain}{Vector with predicted values in the training data set.}

\item{xtest}{Vector with predicted values in the test data set.}

\item{ytrain}{Vector with observed response in the training data set.}

\item{k}{Number of nearest neighbours to choose from. Set \code{k = 0} if no predictive mean matching is to be done.}

\item{seed}{Integer random seed.}
}
\value{
Vector with predicted values in the test data set based on predictive mean matching.
}
\description{
This function is used internally only but might help others 
to implement an efficient way of doing predictive mean matching on top 
of any prediction based missing value imputation. It works as follows:
For each predicted value of a vector \code{xtest}, the closest \code{k} 
predicted values of another vector \code{xtrain} are identified by 
k-nearest neighbour. Then, one of those neighbours are randomly picked 
and its corresponding observed value in \code{ytrain} is returned.
}
\examples{
pmm(xtrain = c(0.2, 0.2, 0.8), xtest = 0.3, ytrain = c(0, 0, 1), k = 1) # 0
pmm(xtrain = c(0.2, 0.2, 0.8), xtest = 0.3, ytrain = c(0, 0, 1), k = 3) # 0 or 1
pmm(xtrain = c("A", "A", "B"), xtest = "B", ytrain = c("B", "A", "B"), k = 1) # B
pmm(xtrain = c("A", "A", "B"), xtest = "B", ytrain = c("B", "A", "B"), k = 2) # A or B
}
