% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRF.R
\name{draw_parameters}
\alias{draw_parameters}
\title{Draw plausible parameter instantiations from a given model}
\usage{
draw_parameters(
  mod,
  draws,
  method = c("parametric", "boostrap"),
  redraws = 20,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mod}{estimated single or multiple-group model}

\item{draws}{number of draws to obtain}

\item{method}{type of plausible values to obtain. Can be 'parametric', for the parametric sampling
scheme which uses the estimated information matrix, or 'boostrap' to obtain values from the \code{\link{boot}}
function. Default is 'parametric'}

\item{redraws}{number of redraws to perform when the given parameteric sample does not satisfy the
upper and lower parameter bounds. If a valid set cannot be found within this number of draws then
an error will be thrown}

\item{verbose}{logical; include additional information in the console?}

\item{...}{additional arguments to be passed}
}
\value{
returns a draws x p matrix of plausible parameters, where each row correspeonds to a single
  set
}
\description{
Draws plausible parameters from a model using parametric sampling (if the information matrix
was computed) or via bootstrap sampling. Primarily for use with the \code{\link{DRF}} function.
}
\examples{

\dontrun{
set.seed(1234)
n <- 40
N <- 500

# only first 5 items as anchors
model <- 'F = 1-40
          CONSTRAINB = (1-5, a1), (1-5, d)'

a <- matrix(1, n)
d <- matrix(rnorm(n), n)
group <- c(rep('Group_1', N), rep('Group_2', N))

## -------------
# groups completely equal
dat1 <- simdata(a, d, N, itemtype = 'dich')
dat2 <- simdata(a, d, N, itemtype = 'dich')
dat <- rbind(dat1, dat2)
mod <- multipleGroup(dat, model, group=group, SE=TRUE,
                     invariance=c('free_means', 'free_var'))

param_set <- draw_parameters(mod, 100)
head(param_set)
}

}
