% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalistGODB.R
\name{joinGO}
\alias{joinGO}
\title{joinGO}
\usage{
joinGO(GOA, GO)
}
\arguments{
\item{GOA}{output of parseGOA()}

\item{GO}{output of parseGOBASIC()}
}
\value{
returns a matrix with columns c("HGNC","GO","RELATION","NAME","ONTOLOGY")
}
\description{
join the outputs of parseGOA and parseGOBASIC to add the GO category name and the ontology to GOA
}
\examples{
GOGOA<-joinGO(GOA,GO)
# GOGOA[1:5,]
# HGNC          GO           RELATION      NAME                    ONTOLOGY            
# [1,] "NUDT4B"      "GO:0003723" "enables"     "RNA binding"           "molecular_function"
# [2,] "NUDT4B"      "GO:0005515" "enables"     "protein binding"       "molecular_function"
# [3,] "NUDT4B"      "GO:0046872" "enables"     "metal ion binding"     "molecular_function"
# [4,] "NUDT4B"      "GO:0005829" "located_in"  "cytosol"               "cellular_component"
# v[5,] "TRBV20OR9-2" "GO:0002376" "involved_in" "immune system process" "biological_process"
# GO_NAME                              
# [1,] "GO_0003723__RNA_binding"          
# [2,] "GO_0005515__protein_binding"      
# [3,] "GO_0046872__metal_ion_binding"    
# [4,] "GO_0005829__cytosol"              
# [5,] "GO_0002376__immune_system_process"

# querying GOGOA to compute gene enrichment of some GO categories
hgncList<-GOGOA[1:1000,"HGNC"]
ontology<-"biological_process"
w<-which(GOGOA[,"ONTOLOGY"] == ontology)
GOGOA<-GOGOA[w,]
w<-which(GOGOA[,"HGNC"] \%in\% hgncList)
t<-sort(table(GOGOA[w,"NAME"]),decreasing=TRUE)[1:10]

}
