% Generated by roxygen2 (4.0.1): do not edit by hand
\name{makeRepo}
\alias{makeRepo}
\title{Downloads packages from CRAN to specified path and creates a local repository.}
\usage{
makeRepo(pkgs, path, repos = getOption("repos"), type = "source",
  Rversion = R.version, download = TRUE, writePACKAGES = TRUE)
}
\arguments{
\item{pkgs}{Character vector of packages to download}

\item{path}{Destination download path. This path is the root folder of your new repository.}

\item{Rversion}{List with two named elements: `major` and `minor`.  If not supplied, defaults to system version of R, using \code{\link[base]{R.version}}.  Only used if \code{type} is not "source"}

\item{download}{If TRUE downloads packages.}

\item{writePACKAGES}{If TRUE, calls \code{\link[tools]{write_PACKAGES}} to update the repository PACKAGES file.}

\item{repos}{URL(s) of the 'contrib' sections of the repositories. Passed to \code{\link{available.packages}}}

\item{type}{Possible values are (currently) "source", "mac.binary" and "win.binary": the binary types can be listed and downloaded but not installed on other platforms.  Passed to \code{\link{download.packages}}.}
}
\description{
Given a list of packages, downloads these packages to a specified destination folder using the required CRAN folder structure, and finally creates the PACKAGES index file.  Since the folder structure mimics the required structure and files of a CRAN repository, it supports functions like \code{\link[utils]{install.packages}()}.
}
\note{
Internally makes use of \code{\link[utils]{download.packages}} and \code{\link[tools]{write_PACKAGES}}
}
\section{Repo folder structure}{

The folder structure of a repository
\itemize{
\item{Root}
\itemize{
\item{src}
\itemize{
\item{contrib}
}
\item{bin}
\itemize{
\item{windows/contrib/}
\item{macosx/contrib/}
\item{macosx/mavericks/contrib}
\item{macosx/leopard/contrib}
}
\item{PACKAGES}
}
}
}
\examples{

# Specify list of packages to download
revolution <- c(CRAN="http://cran.revolutionanalytics.com")
pkgs <- c("foreach")

pdb <- cranJuly2014

\dontrun{
  pdb <- pkgAvail(
    repos = c(CRAN="http://cran.revolutionanalytics.com"),
    type="source"
  )
}

pkgList <- pkgDep(pkgs, availPkgs = pdb, repos=revolution, type="source", suggests=FALSE)
pkgList


\dontrun{
# Create temporary folder for miniCRAN
dir.create(pth <- file.path(tempdir(), "miniCRAN"))

# Make repo for source and win.binary
makeRepo(pkgList, path=pth, repos=revolution, type="source")

# List all files in miniCRAN
list.files(pth, recursive = TRUE)

# Check for available packages
pkgAvail(repos=pth, type="source")

# Repeat process for windows binaries
makeRepo(pkgList, path=pth, repos=revolution, type="win.binary")
pkgAvail(repos=pth, type="win.binary")

# Delete temporary folder
unlink(pth, recursive = TRUE)
}
}
\seealso{
Other miniCRAN.functions: \code{\link{basePkgs}};
  \code{\link{makeDepGraph}}; \code{\link{pkgAvail}};
  \code{\link{pkgDep}}; \code{\link{plot.pkgDepGraph}}
}

