% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{combine_hp_performance}
\alias{combine_hp_performance}
\title{Combine hyperparameter performance metrics for multiple train/test splits}
\usage{
combine_hp_performance(trained_model_lst)
}
\arguments{
\item{trained_model_lst}{List of trained models.}
}
\value{
Named list:
\itemize{
\item \code{dat}: Dataframe of performance metric for each group of hyperparameters
\item \code{params}: Hyperparameters tuned.
\item \code{Metric}: Performance metric used.
}
}
\description{
Combine hyperparameter performance metrics for multiple train/test splits generated by, for instance, \href{http://www.schlosslab.org/mikropml/articles/parallel.html}{looping in R} or using a \href{https://github.com/SchlossLab/mikropml-snakemake-workflow}{snakemake workflow} on a high-performance computer.
}
\examples{
\donttest{
results <- lapply(seq(100, 102), function(seed) {
  run_ml(otu_small, "glmnet", seed = seed, cv_times = 2, kfold = 2)
})
models <- lapply(results, function(x) x$trained_model)
combine_hp_performance(models)
}
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}
}
