#' Early blood development: single cell binary gene expression data
#'
#' Binarized expression data of 33 transcription factors involved
#' in early differentiation of primitive erythroid and endothelial
#' cells (3934 cells).
#'
#' @docType data
#' @name hematoData
#' @usage data(hematoData)
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Moignard et al. (2015) Nat Biotechnol 33(3):269-76
#' (\href{https://pubmed.ncbi.nlm.nih.gov/25355519/}{PubMed link})
#'
#' @keywords data
NULL



#' Genomic and ploidy alterations in breast tumors
#'
#' The dataset contains 807 samples without predisposing Brca1/2 germline mutations
#' and includes 204 somatic mutations (from whole exome sequencing) and expression
#'  level information for 91 genes.
#'
#' @docType data
#' @name cosmicCancer
#' @usage data(cosmicCancer)
#'
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Forbes SA, Beare D, Gunasekaran P, Leung K, Bindal N, et al. (2015)
#' Nucleic Acids Res 43:D805–D811. (\href{https://pubmed.ncbi.nlm.nih.gov/25355519/}{PubMed link})
#'
#' @keywords data
NULL


#' Genomic and ploidy alterations in breast tumors
#'
#' The dataset contains 807 samples without predisposing Brca1/2 germline mutations
#' and includes 204 somatic mutations (from whole exome sequencing) and expression
#'  level information for 91 genes, category order file.
#'
#' @docType data
#' @name cosmicCancer_stateOrder
#' @usage data(cosmicCancer_stateOrder)
#'
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Forbes SA, Beare D, Gunasekaran P, Leung K, Bindal N, et al. (2015)
#' Nucleic Acids Res 43:D805–D811. (\href{https://pubmed.ncbi.nlm.nih.gov/25355519/}{PubMed link})
#'
#' @keywords data
NULL





#' Tetraploidization in vertebrate evolution
#'
#' 20,415 protein-coding genes in the human genome from Ensembl (v70) and information on the
#' retention of duplicates originating either from the two whole genome duplications at
#' the onset of vertebrates (‘ohnolog’) or from subsequent small scale duplications (‘SSD’)
#' as well as copy number variants (‘CNV’).
#'
#' @docType data
#' @name ohno
#' @usage data(ohno)
#'
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Verny et al., PLoS Comp. Bio. 2017.
#'
#' @keywords data
NULL


#' Tetraploidization in vertebrate evolution
#'
#' 20,415 protein-coding genes in the human genome from Ensembl (v70) and information on the
#' retention of duplicates originating either from the two whole genome duplications at
#' the onset of vertebrates (‘ohnolog’) or from subsequent small scale duplications (‘SSD’)
#' as well as copy number variants (‘CNV’), category order.
#'
#' @docType data
#' @usage data(ohno_stateOrder)
#' @format A data.frame object.
#' @keywords datasets
#' @name ohno_stateOrder
#' @references Verny et al., PLoS Comp. Bio. 2017.
#'
#' @keywords data
NULL
