% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_comp.R
\name{multi_comp}
\alias{multi_comp}
\title{Multiplicative Component Description of Origin-Destination Migration Flow Tables}
\usage{
multi_comp(m)
}
\arguments{
\item{m}{\code{matrix} or \code{array} of migration flows}
}
\value{
\code{matrix} or \code{array} of multiplicative components of `m`. When output is an array the total for each table of origin-destination flows is used.
}
\description{
Multiplicative component descriptions of *n*-dimension flow tables based on total reference coding system.
}
\examples{
n <- LETTERS[1:4]
m0 <- matrix(data = c(0, 100, 30, 70, 50, 0, 45, 5, 60, 35, 0, 40, 20, 25, 20, 0), 
             nrow = 4, ncol = 4, dimnames = list(orig = n, dest = n), byrow = TRUE)
addmargins(m0)
multi_comp(m = m0)
}
