% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mig_loglik_grad}
\alias{mig_loglik_grad}
\title{Gradient of the MIG log likelihood with respect to data}
\usage{
mig_loglik_grad(x, xi, Omega, beta)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{xi}{\code{d} vector of location parameters \eqn{\boldsymbol{\xi}}, giving the expected value}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}
}
\value{
an \code{n} by \code{d} matrix of first derivatives for the gradient, observation by observation, or a \code{d} vector if \code{x} is a vector.
}
\description{
This function returns the gradient vector of the log likelihood with respect to the
argument \code{x}.
}
\keyword{internal}
