% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalorFixedProjections.R
\name{Scalarizer}
\alias{Scalarizer}
\title{Scalarizer}
\description{
\code{Scalarizer} objects are functions taking a fitness-matrix \code{fitnesses} (Nindivs x Nobjectives, with higher values indicating higher desirability)
and a list of weight matrices \code{weights} (Nindivs elements of Nobjectives x Nweights matrices; positive weights indicate a positive contribution
to scale) and returns a matrix of scalarizations (Nindivs x Nweights, with higher values indicating greater desirability).

Any other function conforming to these requirements can also be used in place of a \code{Scalarizer}, but the provided \code{Scalarizer} functions cover
the most common use cases.

\code{Scalarizer}s are constructed from constructor-functions, such as \code{\link[=scalarizer_linear]{scalarizer_linear()}} or \code{\link[=scalarizer_chebyshev]{scalarizer_chebyshev()}}.
}
\seealso{
Other Scalarizers: 
\code{\link{scalarizer_chebyshev}()},
\code{\link{scalarizer_linear}()}
}
\concept{Scalarizers}
