% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mies_methods.R
\name{mies_filter_offspring}
\alias{mies_filter_offspring}
\title{Filter Offspring}
\usage{
mies_filter_offspring(
  inst,
  individuals,
  lambda,
  filtor = NULL,
  budget_id = NULL,
  fidelity = NULL,
  get_indivs = TRUE
)
}
\arguments{
\item{inst}{(\code{OptimInstance})\cr
Optimization instance to evaluate.}

\item{individuals}{(\code{data.frame} | \code{\link[data.table:data.table]{data.table}})\cr
Individuals to filter. Must have columns according to \code{filtor$primed_ps}, and must have at least \code{filtor$needed_input(lambda)} rows.}

\item{lambda}{(\code{integer(1)})\cr
Number of individuals to filter down to.}

\item{filtor}{(\code{\link{Filtor}} | \code{NULL})\cr
\code{\link{Filtor}} operator that filters. When \code{NULL} is given, then the \code{\link{FiltorNull}} operation is performed and the first \code{lambda} individuals are
taken from \code{individuals}.}

\item{budget_id}{(\code{character(1)} | \code{NULL})\cr
Budget component when doing multi-fidelity optimization. This component of the search space is added
to \code{individuals} according to \code{fidelity}. Should be \code{NULL} when no multi-fidelity optimization is performed (default).}

\item{fidelity}{(\code{atomic} | \code{NULL})\cr
scalar indicating the value of the \code{budget_id} component with which to evaluate individuals to be filtered.\cr
This value must be \code{NULL} when no multi-fidelity optimization is performed, but it may \strong{also} be \code{NULL} when the
maximum value of the \code{budget_id} found in \code{inst$archive} should be used (the default).}

\item{get_indivs}{(\code{logical(1)})\cr
Whether to return the \code{data.frame} or \code{\link[data.table:data.table]{data.table}} of selected individuals, or an index into \code{individuals}.}
}
\value{
If \code{get_indivs} is \code{TRUE}: a \code{data.frame} or \code{\link[data.table:data.table]{data.table}} (depending on the input type of \code{individuals}) of filtered configurations.
If \code{get_indivs} is \code{FALSE}: an \code{integer} vector indexing the filtered individuals.
}
\description{
Uses a \code{\link{Filtor}} to extract a subset of individuals from a given set. The individuals are either returned directly (when \code{get_indivs} is \code{TRUE})
or in form of an index into the given individuals (when \code{get_indivs} is \code{FALSE}).

\code{\link{Filtor}}s must always select individuals without replacement, so selected individual indices are unique.
}
