% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr.R
\name{crate_env}
\alias{crate_env}
\title{Set a Function's Environment}
\usage{
crate_env(fun, namespace = "R_GlobalEnv", ..., selfref = NULL)
}
\arguments{
\item{fun}{(\code{function})\cr
Function of which the environment should be set.}

\item{namespace}{(\code{character(1)})\cr
Name of the namespace, as given by \code{\link[base:environment]{environmentName()}},
to be used as the (parent of the) environment of \code{fun}. Special values
\code{"R_GlobalEnv"} (global environment), \code{"R_BaseEnv"} (base environment;
note this one is non-standard within R), \code{"R_EmptyEnv"} (empty environment).
The content of the namespace is not modified. Default \code{"R_GlobalEnv"}.}

\item{...}{(\code{list})\cr
Content of environments within which to place \code{fun}.}

\item{selfref}{(\code{character(1)} | named \code{integer} | \code{NULL})\cr
If \code{character(1)}: The name of the entry of the first element in \code{...} that
refers to the function itself. If a named \code{integer}, then the values
indicate the lists in \code{...} where the reference to the function should be
placed see examples. Default \code{NULL}: No reference to the function itself is
present.}
}
\value{
\code{function}: The given \code{fun} with changed environment.
}
\description{
Useful to represent functions efficiently within \code{repr()}.
}
\examples{

identity2 = crate_env(function(x) x, "base")
identical(identity, identity2)  # TRUE

y = 1
f1 = mlr3misc::crate(function(x) x + y, y, .parent = .GlobalEnv)
f2 = crate_env(function(x) x + y, "R_GlobalEnv", list(y = 1))

# Note identical() does not apply because both contain (equal, but not
# identical) 'y = 1'-environments
all.equal(f1, f2)  # TRUE
f1(10)  # 10 + 1 == 11

factorial1 = mlr3misc::crate(
  function(x) if (x > 0) x * factorial1(x - 1) else 1,
  y, .parent = .GlobalEnv
)
environment(factorial1)$factorial1 = factorial1

factorial2 = crate_env(
  function(x) if (x > 0) x * factorial1(x - 1) else 1,
  "R_GlobalEnv", list(y = 1), selfref = "factorial1")
# putting 'factorial1' into the list (or repeating function(x) ....)
# would *not* work, since we want:
identical(environment(factorial2)$factorial1, factorial2)  # TRUE

all.equal(factorial1, factorial2)  # TRUE

g = crate_env(function(x) x + y + z, "miesmuschel",
  list(y = 1), list(z = 2), selfref = c(X = 1, Y = 2, Z = 2))
g(0)  # 0 + 1 + 2 == 3
identical(environment(g)$X, g)
identical(parent.env(environment(g))$Y, g)
identical(parent.env(environment(g))$Z, g)
identical(
  parent.env(parent.env(environment(g))),
  loadNamespace("miesmuschel")
)
}
