% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mies_methods.R
\name{mies_get_generation_results}
\alias{mies_get_generation_results}
\title{Get Performance Values by Generation}
\usage{
mies_get_generation_results(
  inst,
  as_fitnesses = TRUE,
  survivors_only = TRUE,
  condition_on_budget_id = NULL
)
}
\arguments{
\item{inst}{(\code{\link[bbotk:OptimInstance]{OptimInstance}})\cr
Optimization instance to evaluate.}

\item{as_fitnesses}{(\code{logical(1)})\cr
Whether to transform performance values into "fitness" values that are always to be maximized.
This means that values that objectives that should originally be minimized are multiplied with -1,
and that parts of the objective codomain that are neither being minimized nor maximized are dropped.
Default \code{TRUE}.}

\item{survivors_only}{(\code{logical(1)})\cr
Whether to ignore configurations that have \code{"eol"} set to the given generation, i.e. individuals that were killed during that generation.
When this is \code{TRUE} (default), then only individuals that are alive at the \emph{end} of a generation are considered; otherwise all individuals
alive at any point of a generation are considered. If it is \code{TRUE}, this leads to individuals that have \code{"dob"} == \code{"eol"} being ignored.}

\item{condition_on_budget_id}{(\code{character(1)} | \code{NULL})\cr
Budget component when doing multi-fidelity optimization. When this is given, then for each generation, only individuals with the highest value for this
component are considered. If \code{survivors_only} is \code{TRUE}, this means the highest value of all survivors of a given generation, if it is \code{FALSE}, then it
is the highest value of all individuals alive at any point of a generation. To ignore possible budget-parameters, set this to \code{NULL} (default).
This is inparticular necessary when fidelity is not monotonically increasing (e.g. if it is categorical).}
}
\value{
a \code{\link[data.table:data.table]{data.table}} with the column \code{"dob"}, indicating the generation, as well as further
columns named by the \code{\link[bbotk:OptimInstance]{OptimInstance}}'s objectives.
}
\description{
Get evaluated performance values from an \code{\link[bbotk:OptimInstance]{OptimInstance}} for all individuals that were alive
at a given generation. Depending on \code{survivors_only}, all individuals alive at the \emph{end} of a generation are returned,
or all individuals alive at any point during a generation.

The resulting \code{\link[data.table:data.table]{data.table}} object is formatted for easy manipulation to get relevant
information about optimization progress. To get aggregated values per generation, use \code{by = "dob"}.
}
\examples{
library("bbotk")
lgr::threshold("warn")

# Define the objective to optimize
objective <- ObjectiveRFun$new(
  fun = function(xs) {
    z <- 10 - exp(-xs$x^2 - xs$y^2) + 2 * exp(-(2 - xs$x)^2 - (2 - xs$y)^2)
    list(Obj = z)
  },
  domain = ps(x = p_dbl(-2, 4), y = p_dbl(-2, 4)),
  codomain = ps(Obj = p_dbl(tags = "minimize"))
)

oi <- OptimInstanceSingleCrit$new(objective,
  terminator = trm("evals", n_evals = 6)
)

op <- opt("mies",
  lambda = 2, mu = 2,
  mutator = mut("gauss", sdev = 0.1),
  recombinator = rec("xounif"),
  parent_selector = sel("best")
)
set.seed(1)
op$optimize(oi)

# negates objectives that are minimized:
mies_get_generation_results(oi)

# real objective values:
mies_get_generation_results(oi, as_fitnesses = FALSE)

# Individuals that died are included:
mies_get_generation_results(oi, survivors_only = FALSE)
}
