% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecombinatorSequential.R
\name{dict_recombinators_sequential}
\alias{dict_recombinators_sequential}
\alias{RecombinatorSequential}
\title{Run Multiple Recombinator Operations in Sequence}
\description{
\code{\link{Recombinator}} that wraps multiple other \code{\link{Recombinator}}s given during construction and uses them for mutation in sequence.

When subsequent \code{\link{Recombinator}}s have mismatching \code{n_indivs_out} / \code{n_indivs_in}, then \code{RecombinatorSequential} tries to
match them by running them multiple times. If e.g. \code{recombinators[[1]]$n_indivs_out} is 2 and \code{recombinators[[2]]$n_indivs_in} is 1, then
\code{recombinators[[2]]} is run twice, once for each output of \code{recombinators[[1]]}.

When the \code{allow_lcm_packing} argument is \code{FALSE}, then an error is given if neither \code{n_indivs_out} of a \code{\link{Recombinator}} divides \code{n_indivs_in} of the
following \code{\link{Recombinator}}, nor \code{n_indivs_in} of the latter divides \code{n_indivs_out} of the former even when considering that the former is run multiple times.
If \code{allow_lcm_packing} is \code{TRUE}, then both recombinators are run multiple times, according to the lowest common multiple ("lcm")
of the two.

However, \code{allow_lcm_packing} can lead to very large values of \code{n_indivs_in} / \code{n_indivs_out}, so it may instead be preferred to add \code{\link{RecombinatorNull}} objects
with fitting \code{n_indivs_in} / \code{n_indivs_out} values to match subsequent recombinators.
}
\section{Configuration Parameters}{

This operator has the configuration parameters of the \code{\link{Recombinator}}s that it wraps: The configuration parameters of the operator given to the \code{recombinators} construction
argument are prefixed with \code{"recombinator_1"}, \code{"recombinator_2"}, ... up to \code{"recombinator_#"}, where \verb{#} is \code{length(recombinators)}.

Additional configuration parameters:
\itemize{
\item \code{shuffle_between} :: \code{logical(1)} \cr
Whether to reorder \code{values} between invocations of recombinators. Initialized to \code{TRUE}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Param]{Param}} classes are the set intersection of supported classes of the \code{\link{Recombinator}}s given in \code{recombinators}.
}

\section{Dictionary}{

This \code{\link{Recombinator}} can be created with the short access form \code{\link[=rec]{rec()}}
(\code{\link[=recs]{recs()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_recombinators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
rec("sequential", <recombinators>)
recs("sequential", <recombinators>)  # takes vector IDs, returns list of Recombinators

# long form:
dict_recombinators$get("sequential", <recombinators>)
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)

ds = data.frame(a = c(0, 1), b = c(0, 1))
p = ps(a = p_dbl(0, 1), b = p_dbl(0, 1))


convex = rec("cvxpair", lambda = 0.7)
swap = rec("swap")

convex_then_swap = rec("sequential", list(convex, swap))

ds

convex$prime(p)$operate(ds)

swap$prime(p)$operate(ds)

convex_then_swap$prime(p)$operate(ds)
}
\seealso{
Other recombinators: 
\code{\link{OperatorCombination}},
\code{\link{RecombinatorPair}},
\code{\link{Recombinator}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_convex}},
\code{\link{dict_recombinators_cvxpair}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_null}},
\code{\link{dict_recombinators_proxy}},
\code{\link{dict_recombinators_sbx}},
\code{\link{dict_recombinators_swap}},
\code{\link{dict_recombinators_xonary}},
\code{\link{dict_recombinators_xounif}}

Other recombinator wrappers: 
\code{\link{OperatorCombination}},
\code{\link{dict_recombinators_cmpmaybe}},
\code{\link{dict_recombinators_maybe}},
\code{\link{dict_recombinators_proxy}}
}
\concept{recombinator wrappers}
\concept{recombinators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Recombinator]{miesmuschel::Recombinator}} -> \code{RecombinatorSequential}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{recombinators}}{(\code{list} of \code{\link{Recombinator}})\cr
\code{\link{Recombinator}}s being wrapped. These operators get run sequentially in order.}

\item{\code{allow_lcm_packing}}{(\code{logical(1)})\cr
Whether to allow lowest common multiple packing.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RecombinatorSequential-new}{\code{RecombinatorSequential$new()}}
\item \href{#method-RecombinatorSequential-prime}{\code{RecombinatorSequential$prime()}}
\item \href{#method-RecombinatorSequential-clone}{\code{RecombinatorSequential$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorSequential-new"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorSequential-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{RecombinatorSequential} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorSequential$new(recombinators, allow_lcm_packing = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recombinators}}{(\code{list} of \code{\link{Recombinator}})\cr
\code{\link{Recombinator}}s to wrap. The operations are run in order given to \code{recombinators}.
The constructed object gets a \emph{clone} of this argument. The \verb{$recombinators} field will reflect this value.}

\item{\code{allow_lcm_packing}}{(\code{logical(1)})\cr
Whether to allow lowest common multiple packing. Default \code{FALSE}.
The \verb{$allow_lcm_packing} field will reflect this value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorSequential-prime"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorSequential-prime}{}}}
\subsection{Method \code{prime()}}{
See \code{\link{MiesOperator}} method. Primes both this operator, as well as the wrapped operators
given to \code{recombinator} and \code{recombinator_not} during construction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorSequential$prime(param_set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}})\cr
Passed to \code{\link{MiesOperator}}\verb{$prime()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{invisible} \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RecombinatorSequential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RecombinatorSequential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RecombinatorSequential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
