% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_importance.R
\name{mid.importance}
\alias{mid.importance}
\alias{print.mid.importance}
\title{Calculate MID Importance}
\usage{
mid.importance(object, data = NULL, weights = NULL, sort = TRUE, measure = 1L)

\method{print}{mid.importance}(x, digits = max(3L, getOption("digits") - 2L), ...)
}
\arguments{
\item{object}{a "mid" object.}

\item{data}{a data frame containing the observations to be used to calculate the MID importance. If \code{NULL}, the \code{fitted.matrix} of the MID model is used.}

\item{weights}{an optional numeric vector of sample weights.}

\item{sort}{logical. If \code{TRUE}, the output data frame is sorted by MID importance.}

\item{measure}{an integer specifying the measure of the MID importance. Possible alternatives are \code{1} for the mean absolute effect, \code{2} for the root mean square effect, and \code{3} for the median absolute effect.}

\item{x}{a "mid.importance" object to be printed.}

\item{digits}{an integer specifying the minimum number of significant digits to be printed.}

\item{...}{additional parameters to be passed to \code{print.data.frame()} to print the importance of component functions.}
}
\value{
\code{mid.importance()} returns an object of the class "mid.importance" containing the following components.
\item{importance}{the data frame of calculated importances.}
\item{predictions}{the matrix of the fitted or predicted MID values.}
\item{measure}{the type of the importance measure.}
}
\description{
\code{mid.importance()} calculates the MID importance of a fitted MID model.
}
\details{
\code{mid.importance()} returns an object of class "mid.importance".
The MID importance is defined for each component function of a MID model as the mean absolute effect in the given \code{data}.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, airquality, lambda = 1)
imp <- mid.importance(mid)
imp
}
