% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{study_observations}
\alias{study_observations}
\title{Case-study observations}
\format{
\code{data.table} with 8917 rows and 5 columns.

\describe{

\item{\code{mcid}}{Character, anonymized student identifier}

\item{\code{race}}{Character, self-reported race/ethnicity.}

\item{\code{sex}}{Character, self-reported sex.}

\item{\code{program}}{Character, academic program label.}

\item{\code{bloc}}{Character, indicating the grouping (\code{ever_enrolled} or
\code{graduates}) to which an observation belongs.}

}
}
\usage{
study_observations
}
\description{
Data table of post-processed observations of students ever enrolled in, and
students graduating from, the four programs of the case study. Keyed by
student ID. Provided for the convenience of vignette users.
}
\details{
Starting with the case-study starting pool of students ever enrolled in the
four programs of the study (Civil, Electrical, Industrial/Systems, and
Mechanical Engineering), we filtered the data for data sufficiency, degree
seeking, program, and timely completion.

A data frame of "ever enrolled" and a data frame of "timely graduates" were
bound using shared column names and are distinguished in the \code{bloc} variable.
This data structure facilitates grouping and summarizing by race, sex,
program, and group.
}
\seealso{
Other case-study-data: 
\code{\link{baseline_mcid}},
\code{\link{study_programs}},
\code{\link{study_results}}
}
\concept{case-study-data}
\keyword{datasets}
