% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midasreg.R
\name{midas_u}
\alias{midas_u}
\title{Estimate unrestricted MIDAS regression}
\usage{
midas_u(formula, data, ...)
}
\arguments{
\item{formula}{MIDAS regression model formula}

\item{data}{a named list containing data with mixed frequencies}

\item{...}{further arguments, which could be passed to \code{\link{lm}} function.}
}
\value{
\code{\link{lm}} object.
}
\description{
Estimate unrestricted MIDAS regression using OLS. This function is a wrapper for \code{lm}.
}
\details{
MIDAS regression has the following form:

\deqn{y_t = \sum_{j=1}^p\alpha_jy_{t-j} +\sum_{i=0}^{k}\sum_{j=0}^{l_i}\beta_{j}^{(i)}x_{tm_i-j}^{(i)} + u_t,}

where \eqn{x_\tau^{(i)}}, \eqn{i=0,...k} are regressors of higher (or similar) frequency than \eqn{y_t}. 
Given certain assumptions the coefficients can be estimated using usual OLS and they have the familiar properties associated with simple linear regression.
}
\examples{
##The parameter function
theta_h0 <- function(p, dk, ...) {
   i <- (1:dk-1)/100
   pol <- p[3]*i + p[4]*i^2
   (p[1] + p[2]*i)*exp(pol)
}

##Generate coefficients
theta0 <- theta_h0(c(-0.1,10,-10,-10),4*12)

##Plot the coefficients
##Do not run
#plot(theta0)

##' ##Generate the predictor variable
xx <- ts(arima.sim(model = list(ar = 0.6), 600 * 12), frequency = 12)

##Simulate the response variable
y <- midas_sim(500, xx, theta0)

x <- window(xx, start=start(y))

##Create low frequency data.frame
ldt <- data.frame(y=y,trend=1:length(y))

##Create high frequency data.frame

hdt <- data.frame(x=window(x, start=start(y)))

##Fit unrestricted model
mu <- midas_u(y~fmls(x,2,12)-1, list(ldt, hdt))

##Include intercept and trend in regression

mu_it <- midas_u(y~fmls(x,2,12)+trend, list(ldt, hdt))

##Pass data as partialy named list

mu_it <- midas_u(y~fmls(x,2,12)+trend, list(ldt, x=hdt$x))

}
\author{
Virmantas Kvedaras, Vaidotas Zemlys
}
\references{
Kvedaras V., Zemlys, V. \emph{Testing the functional constraints on parameters in regressions with variables of different frequency} Economics Letters 116 (2012) 250-254
}

