% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform_design_with_hierarchical_constrain.r
\name{hc_platform}
\alias{hc_platform}
\title{Bayesian Drug-Combination Platform Design(MIDAS-2)}
\usage{
hc_platform(seed, p, p_tox)
}
\arguments{
\item{seed}{set a random seed to maintain the repeatability of the simulation results.}

\item{p}{a matrix indicating the efficacy. Row number represents the number of candidate drugs.}

\item{p_tox}{a vector indicating the toxicity.}
}
\value{
term.tox the indicator of whether early stopping for toxicity

term.fut the indicator of whether early stopping for futility

term.eff the indicator of whether early stopping for efficacy

final.eff a vector of final decision, either efficacy or inefficacy

post.subg subgroup analysis for treatments

post.sign signature analysis for treatments

post.spike posterior estimation for spike parameters

best selection of best treatment for each subgroup
}
\description{
Implementation of Bayesian drug-combination platform design. More and more immuno-oncology drug combinations make the traditional two-arm phase II trials inefficient, which stimulate the emerge of platform trials. In the case of multiple trial objectives such as candidates screening and subgroup analysis, we propose an information borrowing drug-combination Bayesian design for platform trials with subgroup exploration. MIDAS-2 consists of one control arm and several experimental agents. We use Bayesian spike and slab prior to identify factors that should be included in regression model and borrow information between combinations in the existence of subgroup interaction. Promising drug combinations are allowed to graduated early to move to next stage and new combination strategies can be added accordingly. Catch-up rule, curtail rule and early stopping rules are also applied to accelerate the trial process.
}
\examples{

# Example 1
p0 <- c(    0.1,    0.1,    0.1,   0.1)
p1 <- c(    0.1,    0.1,    0.1,   0.1)

p <- rbind(p0, p1)
p_tox <- c(0.1,0.4)

# consider 1 candidate drugs with 4 subgroups
result <- hc_platform(seed=20,p,p_tox)
result



\donttest{
# Example 2
p0 <- c(    0.1,    0.1,    0.1,   0.1)
p1 <- c(    0.1,    0.1,    0.1,   0.1)
p2 <- c(    0.1,    0.1,    0.1,   0.1)
p3 <- c(    0.1,    0.1,    0.1,   0.1)
p4 <- c(    0.1,    0.1,    0.1,   0.1)
p5 <- c(    0.1,    0.1,    0.1,   0.1)
p6 <- c(    0.1,    0.1,    0.1,   0.1)
p7 <- c(    0.1,    0.1,    0.1,   0.1)

p <- rbind(p0, p1, p2, p3, p4, p5, p6, p7)
p_tox <- c(0.1,0.4,0.1,0.2,0.15,0.1,0.1,0.1)

# consider 7 candidate drugs with 4 subgroups
result <- hc_platform(seed=12,p,p_tox)
result
}

}
