% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_venn.R
\name{trans_venn}
\alias{trans_venn}
\title{Create \code{trans_venn} object for the Venn diagram, petal plot and UpSet plot.}
\description{
This class is a wrapper for a series of intersection analysis related methods, including 2- to 5-way venn diagram, 
more than 5-way petal or UpSet plot and intersection transformations based on David et al. (2012) <doi:10.1128/AEM.01459-12>.
}
\examples{

## ------------------------------------------------
## Method `trans_venn$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- dataset$merge_samples(use_group = "Group")
t1 <- trans_venn$new(dataset = t1, ratio = "numratio")
}

## ------------------------------------------------
## Method `trans_venn$plot_venn`
## ------------------------------------------------

\donttest{
t1$plot_venn()
}

## ------------------------------------------------
## Method `trans_venn$plot_bar`
## ------------------------------------------------

\donttest{
t2 <- t1$plot_bar()
}

## ------------------------------------------------
## Method `trans_venn$trans_comm`
## ------------------------------------------------

\donttest{
t2 <- t1$trans_comm(use_frequency = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_venn-new}{\code{trans_venn$new()}}
\item \href{#method-trans_venn-plot_venn}{\code{trans_venn$plot_venn()}}
\item \href{#method-trans_venn-plot_bar}{\code{trans_venn$plot_bar()}}
\item \href{#method-trans_venn-trans_comm}{\code{trans_venn$trans_comm()}}
\item \href{#method-trans_venn-print}{\code{trans_venn$print()}}
\item \href{#method-trans_venn-clone}{\code{trans_venn$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_venn-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_venn-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$new(dataset, ratio = NULL, name_joint = "&")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} class or a matrix-like table (data.frame or matrix object).
If dataset is a matrix-like table, features must be rows.}

\item{\code{ratio}}{default NULL; NULL, "numratio" or "seqratio"; "numratio": calculate the percentage of feature number; 
"seqratio": calculate the percentage of feature abundance; NULL: no additional percentage.}

\item{\code{name_joint}}{default "&"; the joint mark for generating multi-sample names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data_details} and \code{data_summary} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- dataset$merge_samples(use_group = "Group")
t1 <- trans_venn$new(dataset = t1, ratio = "numratio")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_venn-plot_venn"></a>}}
\if{latex}{\out{\hypertarget{method-trans_venn-plot_venn}{}}}
\subsection{Method \code{plot_venn()}}{
Plot venn diagram.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$plot_venn(
  color_circle = RColorBrewer::brewer.pal(8, "Dark2"),
  fill_color = TRUE,
  text_size = 4.5,
  text_name_size = 6,
  text_name_position = NULL,
  alpha = 0.3,
  linesize = 1.1,
  petal_plot = FALSE,
  petal_color = "#BEAED4",
  petal_color_center = "#BEBADA",
  petal_a = 4,
  petal_r = 1,
  petal_use_lim = c(-12, 12),
  petal_center_size = 40,
  petal_move_xy = 4,
  petal_move_k = 2.3,
  petal_move_k_count = 1.3,
  petal_text_move = 40,
  other_text_show = NULL,
  other_text_position = c(2, 2),
  other_text_size = 5
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_circle}}{default \code{RColorBrewer::brewer.pal(8, "Dark2")}; color pallete.}

\item{\code{fill_color}}{default TRUE; whether fill the area color.}

\item{\code{text_size}}{default 4.5; text size in plot.}

\item{\code{text_name_size}}{default 6; name size in plot.}

\item{\code{text_name_position}}{default NULL; name position in plot.}

\item{\code{alpha}}{default .3; alpha for transparency.}

\item{\code{linesize}}{default 1.1; cycle line size.}

\item{\code{petal_plot}}{default FALSE; whether use petal plot.}

\item{\code{petal_color}}{default "#BEAED4"; color of the petals; If petal_color only has one color value, all the petals will be assigned with this color value.
If petal_color has multiple colors, and the number of color values is smaller than the petal number, 
the function can append more colors automatically with the color interpolation.}

\item{\code{petal_color_center}}{default "#BEBADA"; color of the center in the petal plot.}

\item{\code{petal_a}}{default 4; the length of the ellipse.}

\item{\code{petal_r}}{default 1; scaling up the size of the ellipse.}

\item{\code{petal_use_lim}}{default c(-12, 12); the width of the plot.}

\item{\code{petal_center_size}}{default 40; petal center circle size.}

\item{\code{petal_move_xy}}{default 4; the distance of text to circle.}

\item{\code{petal_move_k}}{default 2.3; the distance of title to circle.}

\item{\code{petal_move_k_count}}{default 1.3; the distance of data text to circle.}

\item{\code{petal_text_move}}{default 40; the distance between two data text.}

\item{\code{other_text_show}}{default NULL; other characters used to show in the plot.}

\item{\code{other_text_position}}{default c(1, 1); the text position for text in \code{other_text_show}.}

\item{\code{other_text_size}}{default 5; the text size for text in \code{other_text_show}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_venn()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_venn-plot_bar"></a>}}
\if{latex}{\out{\hypertarget{method-trans_venn-plot_bar}{}}}
\subsection{Method \code{plot_bar()}}{
Plot the intersections using histogram, i.e. UpSet plot. Especially useful when samples > 5.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$plot_bar(
  left_plot = TRUE,
  sort_samples = TRUE,
  up_y_title = "Intersection size",
  up_y_title_size = 15,
  up_y_text_size = 8,
  up_bar_fill = "grey70",
  bottom_y_text_size = 12,
  bottom_height = 1,
  bottom_point_size = 3,
  bottom_point_color = "black",
  bottom_background_fill = "grey95",
  left_width = 0.3,
  left_bar_fill = "grey70",
  left_x_text_size = 10,
  left_background_fill = "grey95"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{left_plot}}{default TRUE; whether add the left bar plot to show the feature number of each sample.}

\item{\code{sort_samples}}{default TRUE; whether sort samples according to the number of features in each sample.
If FALSE, use the sample orders in sample_table of the raw dataset.}

\item{\code{up_y_title}}{default "Intersection set"; y axis title of upper plot.}

\item{\code{up_y_title_size}}{default 15; y axis title size of upper plot.}

\item{\code{up_y_text_size}}{default 4; y axis text size of upper plot.}

\item{\code{up_bar_fill}}{default "grey70"; bar fill color of upper plot.}

\item{\code{bottom_y_text_size}}{default 12; y axis text size, i.e. sample name size, of bottom sample plot.}

\item{\code{bottom_height}}{default 1; bottom plot height relative to the upper bar plot. 1 represents the height of bottom plot is same with the upper bar plot.}

\item{\code{bottom_point_size}}{default 3; point size of bottom plot.}

\item{\code{bottom_point_color}}{default "black"; point color of bottom plot.}

\item{\code{bottom_background_fill}}{default "grey95"; fill color for the striped background in the bottom sample plot.}

\item{\code{left_width}}{default 0.3; left bar plot width relative to the right bottom plot.}

\item{\code{left_bar_fill}}{default "grey70"; fill color for the left bar plot presenting feature number.}

\item{\code{left_x_text_size}}{default 10; x axis text size of the left bar plot.}

\item{\code{left_background_fill}}{default "grey95"; fill color for the striped background in the left plot.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- t1$plot_bar()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_venn-trans_comm"></a>}}
\if{latex}{\out{\hypertarget{method-trans_venn-trans_comm}{}}}
\subsection{Method \code{trans_comm()}}{
Transform intersection result to community-like microtable object for further composition analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$trans_comm(use_frequency = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_frequency}}{default TRUE; whether only use OTUs occurrence frequency, i.e. presence/absence data; if FALSE, use abundance data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{\link{microtable}} class.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- t1$trans_comm(use_frequency = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_venn-print"></a>}}
\if{latex}{\out{\hypertarget{method-trans_venn-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_venn object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_venn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_venn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_venn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
