% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microtable.R
\name{microtable}
\alias{microtable}
\title{Create microtable object to store and manage all the basic files.}
\format{
microtable.
}
\description{
This class is a wrapper for a series of operations on the original files and the basic manipulations,
including the microtable object creation, data reduction, data rarefaction based on Paul et al. (2013) <doi:10.1371/journal.pone.0061217>, taxa abundance calculation, 
alpha and beta diversity calculation based on the An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and 
Lozupone et al. (2005) <doi:10.1128/AEM.71.12.8228–8235.2005> and other basic operations.\cr
The tutorial website: \href{https://chiliubio.github.io/microeco_tutorial/}{https://chiliubio.github.io/microeco_tutorial/} or
\href{http://chiliubio.gitee.io/microeco_tutorial/}{http://chiliubio.gitee.io/microeco_tutorial/}
}
\examples{

## ------------------------------------------------
## Method `microtable$new`
## ------------------------------------------------

data(otu_table_16S)
data(taxonomy_table_16S)
data(sample_info_16S)
data(phylo_tree_16S)
dataset <- microtable$new(otu_table = otu_table_16S)
dataset <- microtable$new(sample_table = sample_info_16S, otu_table = otu_table_16S, 
  tax_table = taxonomy_table_16S, phylo_tree = phylo_tree_16S)
# trim the files in the dataset
dataset$tidy_dataset()

## ------------------------------------------------
## Method `microtable$filter_pollution`
## ------------------------------------------------

dataset$filter_pollution(taxa = c("mitochondria", "chloroplast"))

## ------------------------------------------------
## Method `microtable$rarefy_samples`
## ------------------------------------------------

\donttest{
dataset$rarefy_samples(sample.size = min(dataset$sample_sums()), replace = TRUE)
}

## ------------------------------------------------
## Method `microtable$tidy_dataset`
## ------------------------------------------------

dataset$tidy_dataset(main_data = TRUE)

## ------------------------------------------------
## Method `microtable$add_rownames2taxonomy`
## ------------------------------------------------

\donttest{
dataset$add_rownames2taxonomy()
}

## ------------------------------------------------
## Method `microtable$cal_abund`
## ------------------------------------------------

\donttest{
dataset$cal_abund()
}

## ------------------------------------------------
## Method `microtable$save_abund`
## ------------------------------------------------

\dontrun{
dataset$save_abund(dirpath = "taxa_abund")
}

## ------------------------------------------------
## Method `microtable$sample_sums`
## ------------------------------------------------

\donttest{
dataset$sample_sums()
}

## ------------------------------------------------
## Method `microtable$taxa_sums`
## ------------------------------------------------

\donttest{
dataset$taxa_sums()
}

## ------------------------------------------------
## Method `microtable$sample_names`
## ------------------------------------------------

\donttest{
dataset$sample_names()
}

## ------------------------------------------------
## Method `microtable$taxa_names`
## ------------------------------------------------

\donttest{
dataset$taxa_names()
}

## ------------------------------------------------
## Method `microtable$rename_taxa`
## ------------------------------------------------

\donttest{
dataset$rename_taxa()
}

## ------------------------------------------------
## Method `microtable$merge_samples`
## ------------------------------------------------

\donttest{
dataset$merge_samples(use_group = "Group")
}

## ------------------------------------------------
## Method `microtable$merge_taxa`
## ------------------------------------------------

\donttest{
dataset$merge_taxa(taxa = "Genus")
}

## ------------------------------------------------
## Method `microtable$cal_alphadiv`
## ------------------------------------------------

\donttest{
dataset$cal_alphadiv(measures = NULL, PD = FALSE)
class(dataset$alpha_diversity)
}

## ------------------------------------------------
## Method `microtable$cal_betadiv`
## ------------------------------------------------

\donttest{
dataset$cal_betadiv(unifrac = FALSE)
class(dataset$beta_diversity)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{microtable$new()}}
\item \href{#method-print}{\code{microtable$print()}}
\item \href{#method-filter_pollution}{\code{microtable$filter_pollution()}}
\item \href{#method-rarefy_samples}{\code{microtable$rarefy_samples()}}
\item \href{#method-tidy_dataset}{\code{microtable$tidy_dataset()}}
\item \href{#method-add_rownames2taxonomy}{\code{microtable$add_rownames2taxonomy()}}
\item \href{#method-cal_abund}{\code{microtable$cal_abund()}}
\item \href{#method-save_abund}{\code{microtable$save_abund()}}
\item \href{#method-sample_sums}{\code{microtable$sample_sums()}}
\item \href{#method-taxa_sums}{\code{microtable$taxa_sums()}}
\item \href{#method-sample_names}{\code{microtable$sample_names()}}
\item \href{#method-taxa_names}{\code{microtable$taxa_names()}}
\item \href{#method-rename_taxa}{\code{microtable$rename_taxa()}}
\item \href{#method-merge_samples}{\code{microtable$merge_samples()}}
\item \href{#method-merge_taxa}{\code{microtable$merge_taxa()}}
\item \href{#method-cal_alphadiv}{\code{microtable$cal_alphadiv()}}
\item \href{#method-save_alphadiv}{\code{microtable$save_alphadiv()}}
\item \href{#method-cal_betadiv}{\code{microtable$cal_betadiv()}}
\item \href{#method-save_betadiv}{\code{microtable$save_betadiv()}}
\item \href{#method-clone}{\code{microtable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$new(
  otu_table,
  sample_table = NULL,
  tax_table = NULL,
  phylo_tree = NULL,
  rep_fasta = NULL,
  auto_tidy = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{otu_table}}{data.frame; necessary; The feature abundance table, rows are features, e.g. species, cols are samples.}

\item{\code{sample_table}}{data.frame; default NULL; The sample information table, rows are samples, cols are sample metadata; 
If not provided, the function can generate a table automatically according to the sample names in otu_table.}

\item{\code{tax_table}}{data.frame; default NULL; The taxonomic information table, rows are species, cols are taxonomic classes.}

\item{\code{phylo_tree}}{phylo; default NULL; The phylogenetic tree; use read.tree function in ape package for input.}

\item{\code{rep_fasta}}{list or DNAStringSet; default NULL; The representative sequences; 
use read.fasta function in seqinr package or readDNAStringSet function in Biostrings package for input.}

\item{\code{auto_tidy}}{default FALSE; Whether trim the files in dataset automatically.
If TRUE, all other operations that}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class "microtable" with the following components:
\describe{
  \item{\code{sample_table}}{The sample information table.}
  \item{\code{otu_table}}{The OTU table.}
  \item{\code{tax_table}}{The taxonomic table.}
  \item{\code{phylo_tree}}{The phylogenetic tree.}
  \item{\code{rep_fasta}}{The representative sequence.}
  \item{\code{taxa_abund}}{default NULL; use cal_abund function to calculate.}
  \item{\code{alpha_diversity}}{default NULL; use cal_alphadiv function to calculate.}
  \item{\code{beta_diversity}}{default NULL; use cal_betadiv function to calculate.}
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(otu_table_16S)
data(taxonomy_table_16S)
data(sample_info_16S)
data(phylo_tree_16S)
dataset <- microtable$new(otu_table = otu_table_16S)
dataset <- microtable$new(sample_table = sample_info_16S, otu_table = otu_table_16S, 
  tax_table = taxonomy_table_16S, phylo_tree = phylo_tree_16S)
# trim the files in the dataset
dataset$tidy_dataset()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the microtable object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-filter_pollution"></a>}}
\if{latex}{\out{\hypertarget{method-filter_pollution}{}}}
\subsection{Method \code{filter_pollution()}}{
Filter the taxa considered as pollution from tax_table.
This operation will remove any line of the tax_table containing any the word in taxa parameter regardless of word case.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$filter_pollution(taxa = c("mitochondria", "chloroplast"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa}}{default: c("mitochondria", "chloroplast"); filter mitochondria and chloroplast, or others as needed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dataset$filter_pollution(taxa = c("mitochondria", "chloroplast"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rarefy_samples"></a>}}
\if{latex}{\out{\hypertarget{method-rarefy_samples}{}}}
\subsection{Method \code{rarefy_samples()}}{
Rarefy communities to make all samples have same species number. See also \code{\link{rrarefy}} for the alternative method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$rarefy_samples(sample.size = NULL, rngseed = 123, replace = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sample.size}}{default:NULL; species number, If not provided, use minimum number of all samples.}

\item{\code{rngseed}}{random seed; default: 123.}

\item{\code{replace}}{default: TRUE; See \code{\link{sample}} for the random sampling.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None; rarefied dataset.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$rarefy_samples(sample.size = min(dataset$sample_sums()), replace = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tidy_dataset"></a>}}
\if{latex}{\out{\hypertarget{method-tidy_dataset}{}}}
\subsection{Method \code{tidy_dataset()}}{
Tidy the object of microtable Class.
Trim files in the object to make taxa and samples consistent across all files in the object. So the results are intersections.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$tidy_dataset(main_data = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{main_data}}{default FALSE; if TRUE, only basic files in microtable object is trimmed. Otherwise, all files, 
including taxa_abund, alpha_diversity and beta_diversity, are all trimed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None, Object of microtable itself cleaned up.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dataset$tidy_dataset(main_data = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_rownames2taxonomy"></a>}}
\if{latex}{\out{\hypertarget{method-add_rownames2taxonomy}{}}}
\subsection{Method \code{add_rownames2taxonomy()}}{
Add the rownames of tax_table as the last column of tax_table. 
This is especially useful when the rownames of tax_table are required as a taxonomic level for the following taxa_abund calculation and biomarker idenfification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$add_rownames2taxonomy(use_name = "OTU")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_name}}{default "OTU"; The column name used in the tax_table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
new tax_table stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$add_rownames2taxonomy()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_abund"></a>}}
\if{latex}{\out{\hypertarget{method-cal_abund}{}}}
\subsection{Method \code{cal_abund()}}{
Calculate the taxonomic abundance at each taxonomic rank.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_abund(
  select_cols = NULL,
  rel = TRUE,
  split_group = FALSE,
  split_by = "&&",
  split_column = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_cols}}{default NULL; numeric vector or character vector of colnames of tax_table; used to select columns to merge and calculate abundances.
This is very useful if there are commented columns or some columns with multiple structure that cannot be used directly.}

\item{\code{rel}}{default TRUE; if TRUE, relative abundance is used; if FALSE, absolute abundance will be summed.}

\item{\code{split_group}}{default FALSE; if TRUE, split the rows to multiple rows according to one or more columns in tax_table. Very useful when multiple mapping info exist.}

\item{\code{split_by}}{default "&&"; Separator delimiting collapsed values; only useful when split_group == TRUE; see sep in separate_rows function.}

\item{\code{split_column}}{default NULL; character vector or list; only useful when split_group == TRUE; character vector: 
fixed column or columns used for the splitting in tax_table in each abundance calculation; 
list: containing more character vectors to assign the column names to each calculation, such as list(c("Phylum"), c("Phylum", "Class")).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
taxa_abund in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$cal_abund()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_abund"></a>}}
\if{latex}{\out{\hypertarget{method-save_abund}{}}}
\subsection{Method \code{save_abund()}}{
Save taxonomic abundance to the computer local place.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_abund(dirpath = "taxa_abund")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "taxa_abund"; directory name to save the taxonomic abundance files.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
dataset$save_abund(dirpath = "taxa_abund")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample_sums"></a>}}
\if{latex}{\out{\hypertarget{method-sample_sums}{}}}
\subsection{Method \code{sample_sums()}}{
Sum the species number for each sample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$sample_sums()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
species number of samples.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$sample_sums()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxa_sums"></a>}}
\if{latex}{\out{\hypertarget{method-taxa_sums}{}}}
\subsection{Method \code{taxa_sums()}}{
Sum the species number for each taxa.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$taxa_sums()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
species number of taxa.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$taxa_sums()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sample_names"></a>}}
\if{latex}{\out{\hypertarget{method-sample_names}{}}}
\subsection{Method \code{sample_names()}}{
Show sample names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$sample_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
sample names.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$sample_names()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taxa_names"></a>}}
\if{latex}{\out{\hypertarget{method-taxa_names}{}}}
\subsection{Method \code{taxa_names()}}{
Show taxa names of tax_table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$taxa_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
taxa names.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$taxa_names()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rename_taxa"></a>}}
\if{latex}{\out{\hypertarget{method-rename_taxa}{}}}
\subsection{Method \code{rename_taxa()}}{
Rename the taxa, including the rownames of otu_table, rownames of tax_table, tip labels of phylogenetic tree and representative sequences.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$rename_taxa(newname_prefix = "ASV_")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newname_prefix}}{default "ASV_"; the prefix of new names; new names will be newname_prefix + numbers according to the rowname order of otu_table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
renamed dataset.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$rename_taxa()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-merge_samples"></a>}}
\if{latex}{\out{\hypertarget{method-merge_samples}{}}}
\subsection{Method \code{merge_samples()}}{
Merge samples according to specific group to generate a new microtable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$merge_samples(use_group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_group}}{the group column in sample_table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new merged microtable object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$merge_samples(use_group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-merge_taxa"></a>}}
\if{latex}{\out{\hypertarget{method-merge_taxa}{}}}
\subsection{Method \code{merge_taxa()}}{
Merge taxa according to specific taxonomic rank to generate a new microtable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$merge_taxa(taxa = "Genus")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa}}{the specific rank in tax_table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new merged microtable object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$merge_taxa(taxa = "Genus")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_alphadiv"></a>}}
\if{latex}{\out{\hypertarget{method-cal_alphadiv}{}}}
\subsection{Method \code{cal_alphadiv()}}{
Calculate alpha diversity in microtable object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_alphadiv(measures = NULL, PD = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{default NULL; one or more indexes from "Observed", "Coverage", "Chao1", "ACE", "Shannon", "Simpson", "InvSimpson", "Fisher", "PD"; 
If null, use all those measures.}

\item{\code{PD}}{TRUE or FALSE, whether phylogenetic tree should be calculated, default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
alpha_diversity stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$cal_alphadiv(measures = NULL, PD = FALSE)
class(dataset$alpha_diversity)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_alphadiv"></a>}}
\if{latex}{\out{\hypertarget{method-save_alphadiv}{}}}
\subsection{Method \code{save_alphadiv()}}{
Save alpha diversity table to the computer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_alphadiv(dirpath = "alpha_diversity")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "alpha_diversity"; directory name to save the alpha_diversity.csv file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_betadiv"></a>}}
\if{latex}{\out{\hypertarget{method-cal_betadiv}{}}}
\subsection{Method \code{cal_betadiv()}}{
Calculate beta diversity in microtable object, including Bray-Curtis, Jaccard, and UniFrac.
See An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and Lozupone et al. (2005) <doi:10.1128/AEM.71.12.8228–8235.2005>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_betadiv(method = NULL, unifrac = FALSE, binary = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default NULL; a character vector with one or more elements; If default, "bray" and "jaccard" will be used; 
see \code{\link{vegdist}} function and method parameter in vegan package.}

\item{\code{unifrac}}{default FALSE; TRUE or FALSE, whether unifrac index should be calculated.}

\item{\code{binary}}{default FALSE; TRUE is used for jaccard and unweighted unifrac; optional for other indexes.}

\item{\code{...}}{parameters passed to \code{\link{vegdist}} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
beta_diversity stored in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
dataset$cal_betadiv(unifrac = FALSE)
class(dataset$beta_diversity)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_betadiv"></a>}}
\if{latex}{\out{\hypertarget{method-save_betadiv}{}}}
\subsection{Method \code{save_betadiv()}}{
Save beta diversity matrix to the computer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_betadiv(dirpath = "beta_diversity")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "beta_diversity"; directory name to save the beta diversity matrix files.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
