% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{build}
\alias{build}
\alias{run}
\title{Build and start the microCRAN site}
\usage{
build(
  repo_dir,
  url_path,
  redirect_url,
  title,
  description,
  contact,
  license,
  tos
)

run(pr, host = "127.0.0.1", port = 1881, url_path, ...)
}
\arguments{
\item{repo_dir}{Path to local directory, where the root of the repository is.
The (source) packages will be stored locally at
\verb{\{repo_dir\}/src/contrib/}.}

\item{url_path}{Optional prefix to endpoint. The CRAN repository will be
available at e.g. \verb{http://127.0.0.1:port/path_prefix/} with the
"contrib.url" as \verb{http://127.0.0.1:port/path_prefix/src/contrib/}.}

\item{redirect_url}{Url, if supplied, requests to static assets
(package files, etc.) are redirected to another service instead of being
handled by \link{cran_static_path_handler}.
It can be beneficial to let e.g. an Apache httpd service handle those.}

\item{title, description, contact, license, tos}{Descriptions of the API.
Some defaults are used, see section below or
\url{https://www.rplumber.io/articles/annotations.html}.}

\item{pr}{A \link[plumber:Plumber]{Plumber-router}, e.g. as returned from
\code{build}.}

\item{host}{A string that is a valid IPv4 or IPv6 address that is owned by
this server, which the application will listen on.
"0.0.0.0" represents all IPv4 addresses and "::/0" represents all IPv6
addresses.}

\item{port}{A number or integer that indicates the server port that should
be listened on. Note that on most Unix-like systems including Linux and
Mac OS X, port numbers smaller than 1025 require root privileges.}

\item{...}{Additional arguments passed on to \code{\link[plumber:pr_run]{plumber::pr_run()}}.}

\item{run}{Logical, should the method run the site immediately?}
}
\value{
A new \link[plumber:Plumber]{Plumber-router} object.
}
\description{
\code{build} creates the \link[plumber:Plumber]{Plumber-router} and
\code{run} starts the service.
}
\details{
Point \code{repo_dir} to you \emph{local} filesystem. If the (sub-)directory does not
exist, it will be created when an R-package is added through the corresponding
endpoint.
}
\section{API Descriptions}{

The fields \code{title}, \code{description}, \code{contact}, \code{license}, and \code{tos}
are used for describing the API in the resulting Swagger-documents.
These follow the OpenAPI type descriptions, see
\url{https://spec.openapis.org/oas/v3.0.3#info-object}.\tabular{lll}{
   Field name \tab Type \tab Description \cr
   title \tab string \tab The title of the API. \cr
   description \tab string \tab A short description of the API. \cr
   tos \tab string \tab A URL to the Terms of Service for the API. \cr
   contact \tab list \tab A "Contact Object", i.e., list-object with fields "name", "url" and "email". \cr
   license \tab list \tab A "License Object", i.e., list-object with fields "name" and "url". \cr
   version \tab string \tab The version of the API. \cr
}
}

