% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_wald.R
\name{prop_wald}
\alias{prop_wald}
\title{Calculates a single proportion and related standard error
according to Wald}
\usage{
prop_wald(x, formula, data)
}
\arguments{
\item{x}{name of variable to calculate proportion.}

\item{formula}{A formula object to specify the model as normally used by glm.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
The proportion, standard error and complete data
degrees of freedom (dfcom) as n-1.
}
\description{
\code{prop_wald} Calculates a single proportion and
related standard error according to Wald and
provides degrees of freedom to be used
in function \code{with.miceafter}.
}
\examples{
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=prop_wald(Chronic ~ 1))

}
\seealso{
\code{\link{with.milist}}, \code{\link{pool_prop_wald}}
}
\author{
Martijn Heymans, 2021
}
