% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_test.R
\name{bf_test}
\alias{bf_test}
\title{Calculates the Brown-Forsythe test.}
\usage{
bf_test(y, x, formula, data)
}
\arguments{
\item{y}{numeric response variable.}

\item{x}{categorical variable.}

\item{formula}{A formula object to specify the model as normally
used by glm. Use 'factor' to define the grouping variable.}

\item{data}{An objects of class \code{milist}, created by
\code{df2milist}, \code{list2milist} or \code{mids2milist}.}
}
\value{
An object containing the following objects are extracted:
\itemize{
\item  \code{fstats} F-test value, including numerator and
denominator degrees of freedom.
\item  \code{qhat} pooled coefficients from fit.
\item  \code{vcov} variance-covariance matrix.
\item  \code{dfcom} degrees of freedom obtained from \code{df.residual}.
}
}
\description{
\code{bf_test} Calculates the Brown-Forsythe test for homogeneity
of variance across groups, coefficients, variance-covariance matrix,
and degrees of freedom.
}
\details{
The Levene's test centers around means to calculate
outcome residuals, the Brown-Forsythe test on the median.
}
\examples{

imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=bf_test(Pain ~ factor(Carrying)))

}
\seealso{
\code{\link{with.milist}}
}
\author{
Martijn Heymans, 2021
}
