\name{mira}
\alias{mira}
\alias{print.mira}
\alias{summary.mira}
\title{Multiply Imputed Repeated Analyses}
\usage{
\method{print}{mira}(x, \dots)
\method{summary}{mira}(object, correlation, \dots)
}

\arguments{
    \item{x, object}{An object containing the \code{m} fit objects of a complete data analysis, 
        plus some additional information.}
    \item{correlation}{}
    \item{\dots}{not used}
}
\description{
  The \code{mira} object is generated by the \code{lm.mids} and \code{glm.mids} functions.
  The \code{mira} class of objects has methods for the following generic functions:
  \code{print}, \code{summary}.}

\value{
  \item{call}{  The call that created the object.}
  \item{call1}{ The call that created the \code{mids} object that was used in \code{call}.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{analyses}{ A list of \code{m} components containing the individual fit objects from each of the \code{m} complete data analyses.}
}

\references{
Van Buuren, S., Groothuis-Oudshoorn, C.G.M. (2000) 
\emph{Multivariate Imputation by Chained Equations:  MICE V1.0 User's manual.} 
Leiden: TNO Quality of Life.
\url{http://www.stefvanbuuren.nl/publications/MICE V1.0 Manual TNO00038 2000.pdf}
}
\author{Stef van Buuren, Karin Groothuis-Oudshoorn, 2000}     
\keyword{misc}  
