% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genClayton2.R
\name{genClayton2}
\alias{genClayton2}
\title{Generates survival data from a bivariate Clayton-Oakes model}
\usage{
genClayton2(n, theta, lambda10, lambda01, lambdaC1, lambdaC2)
}
\arguments{
\item{n}{Sample size for the simulated data set.}

\item{theta}{Parameter for the Clayton copula. Must be -1 or larger.}

\item{lambda10, lambda01}{Rate parameters for the (marginal) exponential
distributions.}

\item{lambdaC1, lambdaC2}{Rate parameters for the censoring times. No
censoring occurs if this paramter is equal to 0.}
}
\value{
A data frame containing the following elements:
\describe{
\item{Y1, Y2:}{Survival times for the simulated data}
\item{Delta1, Delta2:}{Censoring indicators for the simulated data}
}
}
\description{
Generates simulated survival data from a bivariate Clayton-Oakes model,
which can be used to create example data for bivariate survival
function estimation. The marginal distributions are exponential with
given rate parameters. The joint distribution is defined using a Clayton
copula. The censoring times are also exponentially distributed with
given rate parameters.
}
\section{Details}{

This function simulates data with the following survival function:
F(t1,t2) = [F(t1,0)^(-theta) + F(0,t2)^(-theta) - 1]^(-1/theta)
(The survival function is defined to be equal to 0 if this
quantity is negative.) The marginal survival functions F(t1,0) and
F(0,t2) are exponentially distributed with rate parameters lambda10 and
lambda01, respectively. After generating survival times Y1 and Y2 (of
length n) under this distribution, censoring times C1 and C2 (also of
length n) are generated. C1/C2 are generated under an exponential
distribution with rate parameters lambdaC1 and lambdaC2. If
C1[i]<Y1[i] for a given observation i, then observation i is
considered to be censored (i.e., Delta1[i]=0). Delta2 is defined in
a similar manner. If lambdaC1 or lambdaC2 is equal to 0, then the
corresponding variable is uncensored (meaning that Delta[i]=1 for
all i).
}

\examples{
x <- genClayton2(1000, 0, 1, 1, 2, 2)
}
\references{
Clayton, D. "Model for association in bivariate life tables and its
application in epidemiological studies of familial tendency in chronic
disease incidence.", Biometrika (1978) 65:141-151.
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
