% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgamV.R
\name{qgamV}
\alias{qgamV}
\title{Fit a QGAM model and get a gamViz object}
\usage{
qgamV(form, data, qu, lsig = NULL, err = NULL, aQgam = list(), aViz = list())
}
\arguments{
\item{form, data, qu, lsig, err}{same arguments as in \link[qgam:qgam]{qgam::qgam}.}

\item{aQgam}{list of further arguments to be passed to \link[qgam:qgam]{qgam::qgam}.}

\item{aViz}{list of arguments to be passed to \link{getViz}.}
}
\value{
An object of class "gamViz" which can, for instance, be plotted using \link{plot.gamViz}.
}
\description{
These are wrapper that fits a QGAM model using \link[qgam:qgam]{qgam::qgam} and
converts it to a \code{gamViz} object using the \link{getViz} function.
It is essentially a shortcut.
}
\examples{
library(mgcViz)
set.seed(2) ## simulate some data...
dat <- gamSim(2,n=1000,dist="normal",scale=0.25)$data

# Fit GAM and get gamViz object
b <- qgamV(y~s(x) + s(z) + I(x*z), data = dat, qu = 0.2,
           aQgam = list(argGam = list(select = TRUE)), aViz = list("nsim" = 0))

# This is equivalent to doing
# 1. Fit QGAM
# b <- qgam(y~s(x) + s(z) + I(x*z), data=dat, qu = 0.2, argGam = list(select = TRUE))
# 2. Convert to gamViz object
# b <- getViz(b, nsim = 0)

# Either way, we all effects by doing
print(plot(b, allTerms = TRUE), pages = 1)

}
