% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penultimate.R
\name{egp}
\alias{egp}
\title{Extended generalised Pareto families}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{par}{parameter vector (\eqn{\kappa}, \eqn{\sigma},\eqn{\xi}).}

\item{model}{a string indicating which extended family to fit}

\item{p}{extreme event probability; \code{p} must be greater than the rate of exceedance for the calculation to make sense. See \bold{Details}.}

\item{plot}{boolean indicating whether or not to plot the return levels}
}
\value{
\code{egp.ll} returns the log-likelihood value.

\code{egp.retlev} returns a plot of the return levels if \code{plot=TRUE} and a matrix of return levels.
}
\description{
This function provides the log-likelihood and quantiles for the three different families presented
in Papastathopoulos and Tawn (2013). The latter include an additional parameter, \eqn{\kappa}.
All three families share the same tail index than the GP model, while allowing for lower thresholds.
In the case \eqn{\kappa=1}, the models reduce to the generalised Pareto.

\code{egp.retlev} gives the return levels for the extended generalised Pareto distributions
}
\details{
For return levels, the \code{p} argument can be related to \eqn{T} year exceedances as follows:
if there are \eqn{n_y} observations per year, than take \code{p}
to equal \eqn{1/(Tn_y)} to obtain the \eqn{T}-years return level.
}
\section{Usage}{

\code{egp.ll(xdat, thresh, par, model=c("egp1","egp2","egp3"))}


\code{egp.retlev(xdat, thresh, par, model=c("egp1","egp2","egp3"), p, plot=TRUE)}
}
\examples{
set.seed(123)
xdat <- evd::rgpd(1000, loc=0, scale=1, shape=0.5)
par <- egp.fit(xdat, thresh=0, model="egp3")$par
p <- c(1/1000,1/1500,1/2000)
egp.retlev(xdat, 0, par, "egp3",p)
#With multiple thresholds
th <- c(0,0.1,0.2,1)
opt <- egp.fitrange(xdat, th, model="egp1",plots=NA)
egp.retlev(xdat, opt$thresh, opt$par, "egp1",p=p)
opt <- egp.fitrange(xdat, th, model="egp2",plots=NA)
egp.retlev(xdat, opt$thresh, opt$par, "egp2",p=p)
opt <- egp.fitrange(xdat, th, model="egp3",plots=NA)
egp.retlev(xdat, opt$thresh, opt$par, "egp3",p=p)
}
\author{
Leo Belzile
}
\references{
Papastathopoulos, I. and J. Tawn (2013). Extended generalised Pareto models for tail estimation, \emph{Journal of Statistical Planning and Inference} \bold{143}(3), 131--143.
}

