% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{plot.fr}
\alias{plot.fr}
\title{Plot of tangent exponential model profile likelihood}
\usage{
\method{plot}{fr}(x, ...)
}
\arguments{
\item{x}{an object of class \code{fr} returned by \code{\link{gpd.tem}} or \code{\link{gev.tem}}.}

\item{...}{further arguments to \code{plot} currently ignored. Providing a numeric vector \code{which} allows for custom selection of the plots. A logical \code{all}. See \strong{Details}.}
}
\value{
graphs depending on argument \code{which}
}
\description{
This function is adapted from the \code{plot.fr} function from the \code{hoa} package bundle.
It differs from the latter mostly in the placement of legends.
}
\details{
Plots produced depend on the integers provided in \code{which}. \code{1} displays the Wald pivot, the likelihood root \code{r}, the modified likelihood root \code{rstar} and the likelihood modification \code{q} as functions of the parameter \code{psi}. \code{2} gives the renormalized profile log likelihood and adjusted form, with the maximum likelihood having ordinate value of zero. \code{3} provides the significance function, a transformation of \code{1}. Lastly, \code{4} plots the correction factor as a function of the likelihood root; it is a diagnostic plot aimed for detecting failure of
the asymptotic approximation, often due to poor numerics in a neighborhood of \code{r=0}; the function should be smooth. The function \code{\link{spline.corr}} is designed to handle this by correcting numerically unstable estimates, replacing outliers and missing values with the fitted values from the fit.
}
\references{
Brazzale, A. R., Davison, A. C. and Reid, N. (2007). \emph{Applied Asymptotics: Case Studies in Small-Sample Statistics}. Cambridge University Press, Cambridge.
}
