% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{spline.corr}
\alias{spline.corr}
\title{Spline correction for Fraser-Reid approximations}
\usage{
spline.corr(fr)
}
\arguments{
\item{fr}{an object of class \code{fr}, normally the output of \link{gpd.tem} or \link{gev.tem}.}
}
\value{
an object of class \code{fr}, containing as additional arguments \code{spline} and a modified \code{rstar} argument.
}
\description{
The tangent exponential model can be numerically unstable for values close to \eqn{r = 0}.
This function corrects these incorrect values, which are interpolated using splines.
The function takes as input an object of class \code{fr} and returns the same object with
different \code{rstar} values.
}
\details{
If available, the function uses \code{cobs} from the eponym package. The latter handles constraints and smoothness penalties, and is more robust than the equivalent \code{\link[stats]{smooth.spline}}.
}
\section{Warning}{


While penalized (robust) splines often do a good job at capturing and correcting for numerical outliers and \code{NA}, it
may also be driven by unusual values lying on the profile log-likelihood the curve or fail to detect outliers (or falsely identifying `correct' values as outliers). The user should always validate by comparing the plots of both the uncorrected (raw) output of the object with that of \code{spline.corr}.
}

