% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{gpd.bcor}
\alias{gpd.bcor}
\title{Bias correction using Firth's modified score function or bias substraction}
\usage{
gpd.bcor(par, dat, corr = c("subtract", "firth"), method = c("obs", "exp"))
}
\arguments{
\item{par}{parameter vector (\code{scale}, \code{shape})}

\item{dat}{sample of observations}

\item{corr}{string indicating which correction to employ either \code{subtract} or \code{firth}}

\item{method}{string indicating whether to use the expected  (\code{"exp"}) or the observed (\code{"obs"} --- the default) information matrix. Used only if \code{corr="firth"}}
}
\value{
vector of bias-corrected parameters
}
\description{
The routine uses the MLE (bias-corrected) as starting values and proceeds
to find the solution using a root finding algorithm.
Since the bias-correction is not valid for \eqn{xi < -1/3}, any solution that is unbounded
will return a vector of \code{NA} - additionally, passing a \code{par} argument with shape less than -1/3
will return an error if \code{method="subtract"} is selected, as the bias correction does not exist then.
For small samples, expected and observed information can return very different estimates.
}
\examples{
set.seed(1)
dat <- evd::rgpd(n=40, scale=1, shape=-0.2)
par <- mev::gp.fit(dat, threshold=0, show=FALSE)$estimate
gpd.bcor(par,dat, "subtract")
gpd.bcor(par,dat, "firth") #observed information
gpd.bcor(par,dat, "firth","exp")
}

